/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.encoding;

import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.encoding.AbstractEncoding;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import java.io.IOException;
import java.util.Arrays;

public class ISO9796p2s1Encoding
extends AbstractEncoding {
    public static final String NAME = "ISO9796p2s1";
    private int hashLength = -1;
    private byte[] recoverableMessage = new byte[0];
    private boolean completeRecovery = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected byte[] basicDecode(byte[] bytes) throws IOException {
        if (bytes.length < 2 + this.getHashLength()) {
            throw new IOException("message too short");
        }
        if ((bytes[bytes.length - 1] & 0xFF) != 188) {
            throw new IOException("invalid trailer");
        }
        if (this.getHashLength() <= 0) {
            throw new IllegalArgumentException("hash value length unknown.");
        }
        byte[] tempBytes = new byte[this.getHashLength()];
        int digestStart = bytes.length - 1 - this.getHashLength();
        System.arraycopy(bytes, digestStart, tempBytes, 0, this.getHashLength());
        if ((bytes[0] & 0xF) == 10) {
            this.recoverableMessage = new byte[digestStart - 1];
            System.arraycopy(bytes, 1, this.recoverableMessage, 0, this.recoverableMessage.length);
            int header = bytes[0] & 0xF0;
            if (header == 64) {
                this.completeRecovery = true;
                return tempBytes;
            } else {
                if (header != 96) throw new IOException("invalid header");
                this.completeRecovery = false;
            }
            return tempBytes;
        } else {
            int i;
            if (bytes[0] != 75) throw new IOException("invalid header");
            this.completeRecovery = true;
            for (i = 1; i < bytes.length && (0xFF & bytes[i]) == 187; ++i) {
            }
            if (i == bytes.length) {
                throw new IOException("invalid padding");
            }
            if ((0xFF & bytes[i++]) != 186) {
                throw new IOException("invalid padding");
            }
            if (i > digestStart) {
                throw new IOException("invalid padding");
            }
            this.recoverableMessage = new byte[digestStart - i];
            System.arraycopy(bytes, i, this.recoverableMessage, 0, this.recoverableMessage.length);
        }
        return tempBytes;
    }

    @Override
    protected byte[] basicEncode(byte[] bytes) throws IOException {
        byte[] encoded = new byte[this.getIntendedLengthBytes()];
        int maxMsgSize = this.getIntendedLengthBytes() - 2 - bytes.length;
        if (maxMsgSize < 0) {
            throw new IOException("message to long (" + bytes.length + ")");
        }
        if (this.getRecoverableMessage().length > maxMsgSize) {
            this.completeRecovery = false;
            encoded[0] = 106;
            System.arraycopy(this.getRecoverableMessage(), 0, encoded, 1, maxMsgSize);
        } else {
            this.completeRecovery = true;
            int paddingSize = 0;
            if (this.getRecoverableMessage().length == maxMsgSize) {
                encoded[0] = 74;
            } else {
                encoded[0] = 75;
                paddingSize = maxMsgSize - this.getRecoverableMessage().length;
                for (int i = 0; i < paddingSize - 1; ++i) {
                    encoded[1 + i] = -69;
                }
                encoded[paddingSize] = -70;
            }
            System.arraycopy(this.getRecoverableMessage(), 0, encoded, 1 + paddingSize, this.getRecoverableMessage().length);
        }
        System.arraycopy(bytes, 0, encoded, maxMsgSize + 1, bytes.length);
        encoded[encoded.length - 1] = -68;
        return encoded;
    }

    @Override
    protected boolean basicMatch(byte[] bytes, byte[] encoded) throws IOException {
        byte[] rawBytes = null;
        try {
            IDigest digest = DigestTools.decode((byte[])bytes);
            rawBytes = digest.getBytes();
            String algorithm = digest.getAlgorithmName();
            this.setDigestAlgorithmName(algorithm);
        }
        catch (Exception digest) {
            // empty catch block
        }
        byte[] unpadded = this.decode(encoded);
        if (bytes.length == unpadded.length) {
            return Arrays.equals(bytes, unpadded);
        }
        if (rawBytes != null && rawBytes.length == unpadded.length) {
            return Arrays.equals(rawBytes, unpadded);
        }
        return false;
    }

    public int getHashLength() {
        return this.hashLength;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public byte[] getRecoverableMessage() {
        return this.recoverableMessage;
    }

    public boolean isCompleteRecovery() {
        return this.completeRecovery;
    }

    public void setDigestAlgorithmName(String digestAlgorithmName) {
        DigestAlgorithm algorithm = DigestAlgorithm.lookupAlgorithmCanonical(digestAlgorithmName);
        this.setHashLength(algorithm.getSize());
    }

    public void setDigestAlgorithmOid(String digestAlgorithmOid) {
        DigestAlgorithm algorithm = DigestAlgorithm.lookupAlgorithmCanonical(digestAlgorithmOid);
        this.setHashLength(algorithm.getSize());
    }

    public void setHashLength(int hashLength) {
        this.hashLength = hashLength;
    }

    public void setRecoverableMessage(byte[] recoverableMessage) {
        if (recoverableMessage == null) {
            recoverableMessage = new byte[]{};
        }
        this.recoverableMessage = recoverableMessage;
    }
}

