/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.encoding;

import de.intarsys.security.encoding.PKCS1Encoding;
import de.intarsys.tools.crypto.CryptoTools;
import java.io.IOException;
import java.security.SecureRandom;

public class PKCS1Type2Encoding
extends PKCS1Encoding {
    public static final String NAME = "PKCS1Type2";
    private SecureRandom random;

    @Override
    protected void checkPadding(byte value) throws IOException {
        if (value == 0) {
            throw new IOException("illegal padding byte " + Integer.toHexString(value));
        }
    }

    @Override
    protected void fillPadding(byte[] encode, int fromIndex, int toIndex) {
        if (this.random == null) {
            this.random = CryptoTools.createSecureRandom();
        }
        byte[] randomArray = new byte[toIndex - fromIndex];
        this.random.nextBytes(randomArray);
        for (int i = 0; i < randomArray.length; ++i) {
            while (randomArray[i] == 0) {
                randomArray[i] = (byte)this.random.nextInt();
            }
        }
        System.arraycopy(randomArray, 0, encode, fromIndex, randomArray.length);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte getType() {
        return 2;
    }
}

