/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.environment;

import de.intarsys.tools.component.SingletonProvider;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.IPreferencesSupport;
import de.intarsys.tools.preferences.IPreferencesSyncher;
import de.intarsys.tools.preferences.PreferencesFactory;
import de.intarsys.tools.preferences.PreferencesTools;
import de.intarsys.tools.servicelocator.ServiceLocator;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SingletonProvider
public class SecurityEnvironment
implements IPreferencesSupport,
IPreferencesSyncher {
    private static final Logger Log = LoggerFactory.getLogger(SecurityEnvironment.class);
    protected static final String PREFS_SECRET = "secret";
    protected static final String PREFS_ID = "id";
    protected static final String PREFS_SECRETS = "secrets";
    private IPreferences preferences;
    private Map<String, CachedSecret> secrets = new HashMap<String, CachedSecret>();

    public static SecurityEnvironment get() {
        return (SecurityEnvironment)ServiceLocator.get().get(SecurityEnvironment.class);
    }

    protected void basicClearSecret(String id) {
        this.secrets.remove(id);
    }

    protected void basicClearSecrets() {
        this.secrets.clear();
    }

    protected CachedSecret basicGetSecret(String id) {
        return this.secrets.get(id);
    }

    protected void basicSetSecret(String id, Secret secret, boolean store) {
        this.secrets.put(id, new CachedSecret(secret, store));
    }

    public void clearSecret(String id) {
        this.basicClearSecret(id);
        this.preferencesStore();
        try {
            this.getPreferences().flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public void clearSecrets() {
        this.basicClearSecrets();
        this.preferencesStore();
        try {
            this.getPreferences().flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    protected IPreferences createPreferences() {
        String name = this.getPreferencesName();
        IPreferences root = PreferencesFactory.get().getRoot();
        IPreferences result = root.node(name);
        return result;
    }

    public final IPreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = this.createPreferences();
        }
        return this.preferences;
    }

    protected String getPreferencesName() {
        return "de.intarsys.prefs.security.common";
    }

    public Secret getSecret(String id) {
        CachedSecret cpw = this.basicGetSecret(id);
        if (cpw == null || cpw.getValue() == null) {
            return Secret.EMPTY;
        }
        return cpw.getValue();
    }

    @PostConstruct
    public void install() {
        this.preferencesRestore();
    }

    public boolean isSecretCachedPersistent(String id) {
        CachedSecret cpw = this.basicGetSecret(id);
        if (cpw == null) {
            return false;
        }
        return cpw.isStore();
    }

    public boolean isSecretCachedSession(String id) {
        CachedSecret cpw = this.basicGetSecret(id);
        if (cpw == null) {
            return false;
        }
        return !cpw.isStore();
    }

    public void preferencesRestore() {
        IPreferences preferences = this.getPreferences();
        IPreferences secretsNode = preferences.node(PREFS_SECRETS);
        try {
            IPreferences[] entries = secretsNode.children();
            for (int i = 0; i < entries.length; ++i) {
                IPreferences entry = entries[i];
                String id = entry.get(PREFS_ID);
                Secret secret = PreferencesTools.getSecret((IPreferences)entry, (String)PREFS_SECRET, (Secret)Secret.EMPTY);
                this.basicSetSecret(id, secret, true);
            }
        }
        catch (Exception e) {
            Log.warn("could not read secret from preferences", (Throwable)e);
        }
    }

    public void preferencesStore() {
        IPreferences preferences = this.getPreferences();
        IPreferences secretsNode = preferences.node(PREFS_SECRETS);
        int index = 0;
        HashSet<CallSite> newNodeNames = new HashSet<CallSite>();
        for (Map.Entry<String, CachedSecret> entry : this.secrets.entrySet()) {
            CachedSecret cpw = entry.getValue();
            if (!cpw.isStore()) continue;
            String newNodeName = "entry_" + index++;
            newNodeNames.add((CallSite)((Object)newNodeName));
            IPreferences entryNode = secretsNode.node(newNodeName);
            entryNode.put(PREFS_ID, entry.getKey());
            PreferencesTools.putSecret((IPreferences)entryNode, (String)PREFS_SECRET, (Secret)cpw.getValue());
        }
        try {
            String[] childrenNames = secretsNode.childrenNames();
            for (int i = 0; i < childrenNames.length; ++i) {
                String childName = childrenNames[i];
                if (newNodeNames.contains(childName)) continue;
                secretsNode.node(childName).removeNode();
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public void setSecret(String id, Secret secret, boolean store) {
        this.basicSetSecret(id, secret, store);
        this.preferencesStore();
        try {
            this.getPreferences().flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    @PreDestroy
    public void uninstall() {
        this.preferencesStore();
    }

    static class CachedSecret {
        private Secret value;
        private boolean store = false;

        public CachedSecret(Secret secret, boolean store) {
            this.value = secret;
            this.store = store;
        }

        public Secret getValue() {
            return this.value;
        }

        public boolean isStore() {
            return this.store;
        }
    }
}

