/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.extension.common;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.extension.CommonX509ExtensionHandler;
import de.intarsys.security.extension.common.PACKAGE;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.security.cert.X509Extension;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x509.NoticeReference;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.PolicyQualifierInfo;
import org.bouncycastle.asn1.x509.UserNotice;

public class CertificatePoliciesHandler
extends CommonX509ExtensionHandler {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final String id_qt_cps = "1.3.6.1.5.5.7.2.1";
    private static final String id_qt_unotice = "1.3.6.1.5.5.7.2.2";

    @Override
    public String getLabel() {
        return Msg.getString("CertificatePoliciesHandler.Label", new Object[0]);
    }

    @Override
    public String getOID() {
        return "2.5.29.32";
    }

    @Override
    public String getStringValue(X509Extension object) throws IOException {
        ASN1Sequence value = (ASN1Sequence)CertificateTools.getExtensionValue(object, this.getOID());
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Enumeration e = value.getObjects();
        while (e.hasMoreElements()) {
            ASN1Sequence derPolicyQualifiers;
            ASN1Encodable derPolicyInformation = (ASN1Encodable)e.nextElement();
            PolicyInformation policyInformation = PolicyInformation.getInstance((Object)derPolicyInformation);
            ASN1ObjectIdentifier policyIdentifier = policyInformation.getPolicyIdentifier();
            String policiyId = policyIdentifier.getId();
            if (policiyId != null) {
                sb.append("ID: ").append(policiyId).append(StringTools.LS);
            }
            if ((derPolicyQualifiers = policyInformation.getPolicyQualifiers()) != null) {
                Enumeration en = derPolicyQualifiers.getObjects();
                while (en.hasMoreElements()) {
                    ASN1Encodable derPolicyQualifier = (ASN1Encodable)en.nextElement();
                    PolicyQualifierInfo policyQualifierInfo = PolicyQualifierInfo.getInstance((Object)derPolicyQualifier);
                    String id = policyQualifierInfo.getPolicyQualifierId().getId();
                    if (id_qt_cps.equals(id)) {
                        DERIA5String text = (DERIA5String)policyQualifierInfo.getQualifier();
                        sb.append("CPS: ").append(text.getString()).append(StringTools.LS);
                        continue;
                    }
                    if (!id_qt_unotice.equals(id)) continue;
                    UserNotice notice = UserNotice.getInstance((Object)policyQualifierInfo.getQualifier());
                    if (notice.getExplicitText() != null) {
                        String text = notice.getExplicitText().getString();
                        sb.append("User notice: ").append(text).append(System.getProperty("line.separator"));
                    }
                    if (notice.getNoticeRef() == null) continue;
                    NoticeReference reference = notice.getNoticeRef();
                    String organization = reference.getOrganization() == null ? "" : reference.getOrganization().getString();
                    String noticeNumber = "";
                    if (reference.getNoticeNumbers() != null) {
                        StringBuilder number = new StringBuilder();
                        for (ASN1Integer integer : reference.getNoticeNumbers()) {
                            number.append(integer.getValue().intValue());
                        }
                        noticeNumber = number.toString();
                    }
                    StringBuilder infoText = new StringBuilder();
                    infoText.append("--> ");
                    infoText.append(organization);
                    infoText.append(" / ");
                    infoText.append(noticeNumber);
                    sb.append("User notice ref: ").append((CharSequence)infoText).append(System.getProperty("line.separator"));
                }
            }
            sb.append(StringTools.LS);
        }
        return sb.toString();
    }
}

