/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.extension.common;

import de.intarsys.security.extension.IX509ExtensionHandler;
import de.intarsys.security.extension.IX509ExtensionRegistry;
import de.intarsys.security.extension.common.AuditIdentityHandler;
import de.intarsys.security.extension.common.AuthorityInfoAccessHandler;
import de.intarsys.security.extension.common.AuthorityKeyIdentifierHandler;
import de.intarsys.security.extension.common.BasicConstraintsHandler;
import de.intarsys.security.extension.common.BiometricInfoHandler;
import de.intarsys.security.extension.common.CRLDistributionPointsHandler;
import de.intarsys.security.extension.common.CRLNumberHandler;
import de.intarsys.security.extension.common.CertificatePoliciesHandler;
import de.intarsys.security.extension.common.DateOfCertGenHandler;
import de.intarsys.security.extension.common.DefaultX509ExtensionHandler;
import de.intarsys.security.extension.common.DeltaCRLIndicatorHandler;
import de.intarsys.security.extension.common.ExpiredCertsOnCRLHandler;
import de.intarsys.security.extension.common.ExtendedKeyUsageHandler;
import de.intarsys.security.extension.common.ICCSNHandler;
import de.intarsys.security.extension.common.IssuerAltNamesHandler;
import de.intarsys.security.extension.common.IssuingDistributionPointHandler;
import de.intarsys.security.extension.common.KeyUsageHandler;
import de.intarsys.security.extension.common.NameConstraintsHandler;
import de.intarsys.security.extension.common.NetscapeCertificateTypeHandler;
import de.intarsys.security.extension.common.NoRevAvailHandler;
import de.intarsys.security.extension.common.OCSPNocheckHandler;
import de.intarsys.security.extension.common.PolicyConstraintsHandler;
import de.intarsys.security.extension.common.PolicyMappingsHandler;
import de.intarsys.security.extension.common.PrivateKeyUsagePeriodHandler;
import de.intarsys.security.extension.common.QCStatementsHandler;
import de.intarsys.security.extension.common.SubjectAltNamesHandler;
import de.intarsys.security.extension.common.SubjectKeyIdentifierHandler;
import de.intarsys.security.extension.common.TargetsHandler;
import de.intarsys.security.extension.common.ValidityModelHandler;
import java.util.HashMap;
import java.util.Map;

public class DefaultExtensionRegistry
implements IX509ExtensionRegistry {
    private Map handlers = new HashMap();

    public DefaultExtensionRegistry() {
        this.initDefault();
    }

    protected void initDefault() {
        this.registerExtensionHandler(new AuditIdentityHandler());
        this.registerExtensionHandler(new AuthorityInfoAccessHandler());
        this.registerExtensionHandler(new AuthorityKeyIdentifierHandler());
        this.registerExtensionHandler(new BasicConstraintsHandler());
        this.registerExtensionHandler(new BiometricInfoHandler());
        this.registerExtensionHandler(new CertificatePoliciesHandler());
        this.registerExtensionHandler(new CRLDistributionPointsHandler());
        this.registerExtensionHandler(new CRLNumberHandler());
        this.registerExtensionHandler(new DeltaCRLIndicatorHandler());
        this.registerExtensionHandler(new ExpiredCertsOnCRLHandler());
        this.registerExtensionHandler(new ExtendedKeyUsageHandler());
        this.registerExtensionHandler(new IssuerAltNamesHandler());
        this.registerExtensionHandler(new IssuingDistributionPointHandler());
        this.registerExtensionHandler(new KeyUsageHandler());
        this.registerExtensionHandler(new NameConstraintsHandler());
        this.registerExtensionHandler(new NoRevAvailHandler());
        this.registerExtensionHandler(new OCSPNocheckHandler());
        this.registerExtensionHandler(new PolicyConstraintsHandler());
        this.registerExtensionHandler(new PolicyMappingsHandler());
        this.registerExtensionHandler(new PrivateKeyUsagePeriodHandler());
        this.registerExtensionHandler(new QCStatementsHandler());
        this.registerExtensionHandler(new SubjectAltNamesHandler());
        this.registerExtensionHandler(new SubjectKeyIdentifierHandler());
        this.registerExtensionHandler(new TargetsHandler());
        this.registerExtensionHandler(new DateOfCertGenHandler());
        this.registerExtensionHandler(new ValidityModelHandler());
        this.registerExtensionHandler(new NetscapeCertificateTypeHandler());
        this.registerExtensionHandler(new ICCSNHandler());
    }

    @Override
    public IX509ExtensionHandler lookupExtensionHandler(String oid) {
        IX509ExtensionHandler handler = (IX509ExtensionHandler)this.handlers.get(oid);
        if (handler == null) {
            handler = new DefaultX509ExtensionHandler(oid);
            this.registerExtensionHandler(handler);
        }
        return handler;
    }

    @Override
    public void registerExtensionHandler(IX509ExtensionHandler handler) {
        this.handlers.put(handler.getOID(), handler);
    }

    @Override
    public void unregisterExtensionHandler(IX509ExtensionHandler handler) {
        this.handlers.remove(handler.getOID());
    }
}

