/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.extension.common;

import de.intarsys.asn1.common.Attribute;
import de.intarsys.asn1.common.AttributeAny;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Attribute;
import de.intarsys.security.certificate.attribute.IX509AttributeFactory;
import de.intarsys.security.certificate.attribute.UnknownAttribute;
import de.intarsys.security.certificate.attribute.X509AttributeFactory;
import de.intarsys.security.extension.CommonX509ExtensionHandler;
import java.io.IOException;
import java.security.cert.X509Extension;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERNull;

class DefaultX509ExtensionHandler
extends CommonX509ExtensionHandler {
    private String oid;

    public DefaultX509ExtensionHandler(String oid) {
        this.oid = oid;
    }

    protected IX509Attribute createAttribute() {
        try {
            return this.createAttribute((ASN1Primitive)DERNull.INSTANCE);
        }
        catch (IOException e) {
            return null;
        }
    }

    protected IX509Attribute createAttribute(ASN1Primitive value) throws IOException {
        IX509AttributeFactory factory = X509AttributeFactory.get();
        IX509Attribute attr = factory.create((Attribute)AttributeAny.create((String)this.oid, (ASN1Encodable)value));
        if (attr instanceof UnknownAttribute) {
            attr = null;
        }
        return attr;
    }

    protected IX509Attribute createAttribute(X509Extension object) throws IOException {
        ASN1Primitive value = CertificateTools.getExtensionValue(object, this.oid);
        return this.createAttribute(value);
    }

    @Override
    public String getLabel() {
        IX509Attribute attr = this.createAttribute();
        if (attr != null) {
            return attr.getLabel();
        }
        return "";
    }

    @Override
    public String getOID() {
        return this.oid;
    }

    @Override
    public String getStringValue(X509Extension object) throws IOException {
        IX509Attribute attr = this.createAttribute(object);
        if (attr != null) {
            return attr.getStringValue();
        }
        return super.getStringValue(object);
    }
}

