/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.extension.common;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.extension.CommonX509ExtensionHandler;
import de.intarsys.security.extension.common.PACKAGE;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import java.security.cert.X509Extension;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Primitive;

public class ExpiredCertsOnCRLHandler
extends CommonX509ExtensionHandler {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance();

    @Override
    public String getLabel() {
        return Msg.getString("ExpiredCertsOnCRLHandler.Label", new Object[0]);
    }

    @Override
    public String getOID() {
        return "2.5.29.60";
    }

    @Override
    public String getStringValue(X509Extension object) throws IOException {
        Date date;
        ASN1Primitive value = CertificateTools.getExtensionValue(object, this.getOID());
        ASN1GeneralizedTime derValue = ASN1GeneralizedTime.getInstance((Object)value);
        if (derValue == null) {
            return null;
        }
        try {
            date = derValue.getDate();
        }
        catch (ParseException e) {
            return super.getStringValue(object);
        }
        if (date == null) {
            return super.getStringValue(object);
        }
        String formattedDate = DATE_FORMAT.format(date);
        return Msg.getString("ExpiredCertsOnCRLHandler.Description", new Object[]{formattedDate});
    }
}

