/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.extension.common;

import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.extension.common.CommonX509Extension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.KeyPurposeId;

public class X509ExtensionExtendedKeyUsage
extends CommonX509Extension {
    public static final String OID = "2.5.29.37";
    private List<String> usage = new ArrayList<String>();

    public static X509ExtensionExtendedKeyUsage create(byte[] encoded) throws IOException {
        ExtendedKeyUsage eku = ExtendedKeyUsage.getInstance((Object)ASN1Tools.create((byte[])encoded));
        ArrayList<String> usages = new ArrayList<String>();
        for (KeyPurposeId keyPurposeId : eku.getUsages()) {
            usages.add(keyPurposeId.getId());
        }
        return new X509ExtensionExtendedKeyUsage(usages);
    }

    public X509ExtensionExtendedKeyUsage() {
    }

    public X509ExtensionExtendedKeyUsage(List<String> usage) {
        this.usage.addAll(usage);
    }

    public void addUsage(String id) {
        this.usage.add(id);
    }

    @Override
    public String getOid() {
        return OID;
    }

    public List<String> getUsage() {
        return new ArrayList<String>(this.usage);
    }

    @Override
    public byte[] getValue() throws IOException {
        Vector<KeyPurposeId> usages = new Vector<KeyPurposeId>();
        for (String usageId : this.getUsage()) {
            usages.add(KeyPurposeId.getInstance((Object)new ASN1ObjectIdentifier(usageId)));
        }
        return new ExtendedKeyUsage(usages).getEncoded("DER");
    }

    public void setUsage(List<String> usage) {
        this.usage = usage;
    }
}

