/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.extension.common;

import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.extension.common.CommonX509Extension;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.x509.KeyUsage;

public class X509ExtensionKeyUsage
extends CommonX509Extension {
    public static final String OID = "2.5.29.15";
    private int usage = 0;

    public static X509ExtensionKeyUsage create(byte[] encoded) throws IOException {
        DERBitString ku = DERBitString.convert((ASN1BitString)ASN1BitString.getInstance((Object)ASN1Tools.create((byte[])encoded)));
        return new X509ExtensionKeyUsage(ku.intValue());
    }

    public X509ExtensionKeyUsage() {
        this.setCritical(true);
    }

    public X509ExtensionKeyUsage(int usage) {
        this.setUsage(usage);
        this.setCritical(true);
    }

    public void addUsageCRLSign() {
        this.setUsage(this.getUsage() | 2);
    }

    public void addUsageDataEncipherment() {
        this.setUsage(this.getUsage() | 0x10);
    }

    public void addUsageDecipherOnly() {
        this.setUsage(this.getUsage() | 0x8000);
    }

    public void addUsageDigitalSignature() {
        this.setUsage(this.getUsage() | 0x80);
    }

    public void addUsageEncipherOnly() {
        this.setUsage(this.getUsage() | 1);
    }

    public void addUsageKeyAgreement() {
        this.setUsage(this.getUsage() | 8);
    }

    public void addUsageKeyCertSign() {
        this.setUsage(this.getUsage() | 4);
    }

    public void addUsageKeyEncipherment() {
        this.setUsage(this.getUsage() | 0x20);
    }

    public void addUsageNonRepudiation() {
        this.setUsage(this.getUsage() | 0x40);
    }

    @Override
    public String getOid() {
        return OID;
    }

    public int getUsage() {
        return this.usage;
    }

    @Override
    public byte[] getValue() throws IOException {
        return new KeyUsage(this.usage).getEncoded("DER");
    }

    protected boolean isUsage(int usageBit) {
        return (this.getUsage() & usageBit) != 0;
    }

    public boolean isUsageCRLSign() {
        return this.isUsage(2);
    }

    public boolean isUsageDataEncipherment() {
        return this.isUsage(16);
    }

    public boolean isUsageDecipherOnly() {
        return this.isUsage(32768);
    }

    public boolean isUsageDigitalSignature() {
        return this.isUsage(128);
    }

    public boolean isUsageEncipherOnly() {
        return this.isUsage(1);
    }

    public boolean isUsageKeyAgreement() {
        return this.isUsage(8);
    }

    public boolean isUsageKeyCertSign() {
        return this.isUsage(4);
    }

    public boolean isUsageKeyEncipherment() {
        return this.isUsage(32);
    }

    public boolean isUsageNonRepudiation() {
        return this.isUsage(64);
    }

    public void setUsage(int usage) {
        this.usage = usage;
    }
}

