/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.keystore.multi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiFileKeyStore
extends KeyStoreSpi {
    private static final String JKS = "JKS";
    private static final String PKCS12 = "PKCS12";
    private List keystores = new ArrayList();
    private Map aliasMap = new HashMap();
    private boolean jks = false;
    private boolean pkcs12 = false;
    private IOException lastLoadException;

    public MultiFileKeyStore() {
        this.checkKeyStoreImplementations();
    }

    private void checkKeyStoreImplementations() {
        try {
            KeyStore.getInstance(JKS);
            this.jks = true;
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        try {
            KeyStore.getInstance(PKCS12);
            this.pkcs12 = true;
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
    }

    public Enumeration engineAliases() {
        return Collections.enumeration(this.getAliasMap().keySet());
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.getAliasMap().containsKey(alias);
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        KeyStore store = this.getKeyStore(alias);
        if (store != null) {
            store.deleteEntry(alias);
        }
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        KeyStore store = this.getKeyStore(alias);
        if (store != null) {
            try {
                return store.getCertificate(alias);
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        for (KeyStore k : this.getKeystores()) {
            String alias;
            try {
                alias = k.getCertificateAlias(cert);
            }
            catch (KeyStoreException e) {
                continue;
            }
            if (alias == null) continue;
            return alias;
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        KeyStore store = this.getKeyStore(alias);
        if (store != null) {
            try {
                return store.getCertificateChain(alias);
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        KeyStore store = this.getKeyStore(alias);
        if (store != null) {
            try {
                return store.getCreationDate(alias);
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyStore store = this.getKeyStore(alias);
        if (store != null) {
            try {
                return store.getKey(alias, password);
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        KeyStore store = this.getKeyStore(alias);
        if (store != null) {
            try {
                return store.isCertificateEntry(alias);
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        KeyStore store = this.getKeyStore(alias);
        if (store != null) {
            try {
                return store.isKeyEntry(alias);
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (stream == null) {
            return;
        }
        KeyStore keyStore = null;
        if (this.foundJKS()) {
            keyStore = this.loadKeyStore(JKS, stream, password);
        }
        if (keyStore == null && this.foundPKCS12()) {
            keyStore = this.loadKeyStore(PKCS12, stream, password);
        }
        if (keyStore == null) {
            throw this.lastLoadException;
        }
        this.getKeystores().add(keyStore);
        try {
            Enumeration<String> e = keyStore.aliases();
            while (e.hasMoreElements()) {
                this.getAliasMap().put(e.nextElement(), keyStore);
            }
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        KeyStore store = this.getKeyStore(alias);
        if (store != null) {
            try {
                store.setCertificateEntry(alias, cert);
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
        }
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        KeyStore store = this.getKeyStore(alias);
        if (store != null) {
            store.setKeyEntry(alias, key, chain);
        }
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        KeyStore store = this.getKeyStore(alias);
        if (store != null) {
            try {
                store.setKeyEntry(alias, key, password, chain);
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
        }
    }

    @Override
    public int engineSize() {
        return this.getAliasMap().size();
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
    }

    private boolean foundJKS() {
        return this.jks;
    }

    private boolean foundPKCS12() {
        return this.pkcs12;
    }

    private Map getAliasMap() {
        return this.aliasMap;
    }

    private KeyStore getKeyStore(String alias) {
        return (KeyStore)this.getAliasMap().get(alias);
    }

    private List getKeystores() {
        return this.keystores;
    }

    private KeyStore loadKeyStore(String type, InputStream stream, char[] password) throws NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = null;
        try {
            try {
                keyStore = KeyStore.getInstance(type);
                keyStore.load(stream, password);
            }
            catch (KeyStoreException keyStoreException) {}
        }
        catch (IOException e) {
            this.lastLoadException = e;
            return null;
        }
        return keyStore;
    }
}

