/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.keystore.pkcs7;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.asn1.cms.CertificateSet;
import de.intarsys.asn1.cms.IssuerAndSerialNumber;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1BasedTools;
import de.intarsys.asn1.x509.Certificate;
import de.intarsys.asn1.x509.CertificateSerialNumber;
import de.intarsys.asn1.x509.Name;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreSpi;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class PKCS7KeyStoreSpi
extends KeyStoreSpi {
    private CertificateFactory cf;
    private CertificateSet certificateSet;
    private Map aliases;
    private Object lock = new Object();

    private Map aliases() {
        return this.aliases;
    }

    public Enumeration engineAliases() {
        return Collections.enumeration(this.aliases().keySet());
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.aliases().containsKey(alias);
    }

    @Override
    public void engineDeleteEntry(String alias) {
    }

    @Override
    public java.security.cert.Certificate engineGetCertificate(String alias) {
        IssuerAndSerialNumber ref = (IssuerAndSerialNumber)this.aliases().get(alias);
        if (ref != null) {
            Certificate cert = this.certificateSet.getCertificate(ref);
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(cert.getDEREncoded());
                return this.getCF().generateCertificate(in);
            }
            catch (IOException iOException) {
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String engineGetCertificateAlias(java.security.cert.Certificate cert) {
        X509Certificate x509Cert = (X509Certificate)cert;
        byte[] enc = x509Cert.getIssuerX500Principal().getEncoded();
        Name issuer = null;
        try {
            issuer = (Name)ASN1BasedTools.create((ASN1Based.Factory)Name.FACTORY, (byte[])enc);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        CertificateSerialNumber serial = (CertificateSerialNumber)CertificateSerialNumber.FACTORY.createNew();
        serial.setValue(x509Cert.getSerialNumber());
        IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.create((Name)issuer, (CertificateSerialNumber)serial);
        return issuerAndSerialNumber.toString();
    }

    @Override
    public java.security.cert.Certificate[] engineGetCertificateChain(String alias) {
        IssuerAndSerialNumber ref = (IssuerAndSerialNumber)this.aliases().get(alias);
        if (ref != null) {
            return new java.security.cert.Certificate[]{this.engineGetCertificate(alias)};
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        return null;
    }

    @Override
    public Key engineGetKey(String alias, char[] password) {
        return null;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return this.engineContainsAlias(alias);
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            CMS cms = (CMS)ASN1BasedTools.create((ASN1Based.Factory)CMS.FACTORY, (InputStream)stream);
            if (cms.isSignedData()) {
                this.certificateSet = cms.getSignedData().getCertificates();
            }
            if (this.certificateSet == null) {
                throw new IOException("CMS must be of type 'SignedData' and contain certificates");
            }
            this.aliases = new HashMap();
            for (int i = 0; i < this.certificateSet.size(); ++i) {
                Certificate cert = this.certificateSet.get(i);
                IssuerAndSerialNumber issuerAndSerial = cert.getIssuerAndSerialNumber();
                this.aliases.put(issuerAndSerial.toString(), issuerAndSerial);
            }
        }
    }

    @Override
    public void engineSetCertificateEntry(String alias, java.security.cert.Certificate cert) {
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, java.security.cert.Certificate[] chain) {
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, java.security.cert.Certificate[] chain) {
    }

    @Override
    public int engineSize() {
        return this.certificateSet.size();
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CertificateFactory getCF() {
        Object object = this.lock;
        synchronized (object) {
            if (this.cf == null) {
                try {
                    this.cf = CertificateFactory.getInstance("X.509");
                }
                catch (CertificateException certificateException) {
                    // empty catch block
                }
            }
            return this.cf;
        }
    }
}

