/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.privatekey;

import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.privatekey.IPrivateKeyProvider;
import de.intarsys.security.privatekey.IPrivateKeyProviderSupport;
import de.intarsys.security.privatekey.PrivateKeyProvider;

public class PrivateKeyProviderTools {
    public static IPrivateKeyProvider getKeyProvider(IX509PublicKeyCertificate certificate) {
        if (certificate == null) {
            return null;
        }
        IPrivateKeyProvider provider = null;
        if (certificate instanceof IPrivateKeyProviderSupport) {
            provider = ((IPrivateKeyProviderSupport)((Object)certificate)).getKeyProvider();
        }
        if ((provider == null || !provider.hasPrivateKey(certificate)) && certificate.getCertificateProvider() instanceof IPrivateKeyProvider) {
            provider = (IPrivateKeyProvider)((Object)certificate.getCertificateProvider());
        }
        if (provider == null || !provider.hasPrivateKey(certificate)) {
            provider = PrivateKeyProviderTools.lookupKeyProvider(certificate);
        }
        if (provider == null) {
            return null;
        }
        return provider;
    }

    protected static IPrivateKeyProvider lookupKeyProvider(IX509PublicKeyCertificate certificate) {
        return PrivateKeyProviderTools.lookupKeyProvider(certificate, PrivateKeyProvider.get());
    }

    protected static IPrivateKeyProvider lookupKeyProvider(IX509PublicKeyCertificate certificate, IPrivateKeyProvider current) {
        if (current.hasPrivateKey(certificate)) {
            return current;
        }
        return null;
    }
}

