/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.privatekey;

import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.privatekey.IPasswordProtectionSupport;
import de.intarsys.security.privatekey.IPrivateKeyProvider;
import de.intarsys.security.privatekey.PrivateKeyProviderTools;
import de.intarsys.tools.authenticate.IPasswordProvider;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;

public class PrivateKeyTools {
    public static PrivateKey getPrivateKey(IX509PublicKeyCertificate certificate, IPasswordProvider passwordProvider) throws UnrecoverableKeyException, IOException {
        IPrivateKeyProvider provider = PrivateKeyProviderTools.getKeyProvider(certificate);
        if (provider == null) {
            return null;
        }
        return provider.getPrivateKey(certificate, passwordProvider);
    }

    public static boolean hasPrivateKey(IX509PublicKeyCertificate certificate) {
        IPrivateKeyProvider provider = PrivateKeyProviderTools.getKeyProvider(certificate);
        return provider != null;
    }

    public static boolean isPrivateKeyPasswordProtected(IX509PublicKeyCertificate certificate) {
        IPrivateKeyProvider provider = PrivateKeyProviderTools.getKeyProvider(certificate);
        if (provider == null) {
            return false;
        }
        if (provider instanceof IPasswordProtectionSupport) {
            return ((IPasswordProtectionSupport)((Object)provider)).isPrivateKeyPasswordProtected(certificate);
        }
        return true;
    }

    private PrivateKeyTools() {
    }
}

