/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.signature;

import de.intarsys.security.app.validation.ISignatureContainerValidator;
import de.intarsys.security.app.validation.ISignatureContainerValidatorFactory;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.security.signature.ISignatureContainerEntry;
import de.intarsys.tools.adapter.IAdapterSupport;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.locator.ILocator;

public abstract class AbstractSignatureContainer<T extends ISignatureContainerEntry>
implements ISignatureContainer<T>,
IAdapterSupport,
INotificationSupport {
    public static final String ATTR_LOCATOR = "locator";
    private EventDispatcher dispatcher = new EventDispatcher((Object)this);
    private final IAttributeSupport attributeSupport = new AttributeMap();
    private final Object impl;

    protected AbstractSignatureContainer(Object impl) {
        this.impl = impl;
    }

    public void addNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.addNotificationListener(type, listener);
    }

    protected ISignatureContainerValidator createSignatureContainerValidator() {
        return null;
    }

    protected ISignatureContainerValidatorFactory createSignatureContainerValidatorFactory() {
        return null;
    }

    public <C> C getAdapter(Class<C> clazz) {
        if (clazz == ISignatureContainerValidatorFactory.class) {
            return (C)this.createSignatureContainerValidatorFactory();
        }
        if (clazz == ISignatureContainerValidator.class) {
            return (C)this.createSignatureContainerValidator();
        }
        return null;
    }

    public final Object getAttribute(Object key) {
        return this.attributeSupport.getAttribute(key);
    }

    public String getContentType() {
        return "application/octet-stream";
    }

    @Override
    public Object getImpl() {
        return this.impl;
    }

    @Override
    public int getSize() {
        return this.getEntries().size();
    }

    @Override
    public boolean isDetached() {
        return false;
    }

    public boolean isInternal() {
        return !this.isDetached();
    }

    protected void locatorChanged(ILocator oldValue, ILocator newValue) {
        this.triggerChanged(ATTR_LOCATOR, oldValue, newValue);
    }

    public final Object removeAttribute(Object key) {
        return this.attributeSupport.removeAttribute(key);
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.removeNotificationListener(type, listener);
    }

    public final Object setAttribute(Object key, Object o) {
        return this.attributeSupport.setAttribute(key, o);
    }

    protected void triggerChanged(Object attribute, Object oldValue, Object newValue) {
        this.dispatcher.triggerChanged(attribute, oldValue, newValue);
    }

    protected void triggerEvent(Event event) {
        this.dispatcher.triggerEvent(event);
    }
}

