/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.signature.common;

import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.ocsp.IOCSPResponse;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.SignatureData;
import de.intarsys.security.standard.validation.ExtendedValidationData;
import de.intarsys.security.timestamp.ITimestampSupport;
import de.intarsys.security.timestamp.ITimestampToken;
import de.intarsys.security.validation.IExtendedValidationData;
import de.intarsys.security.validation.IExtendedValidationDataSupport;

public class ExtendedSignatureData
extends SignatureData
implements ITimestampSupport,
IExtendedValidationDataSupport {
    private final ITimestampToken timestamp;
    private final IExtendedValidationData validationData;

    public static ISignatureData create(byte[] encodedSignature, ITimestampToken timestamp) {
        return ExtendedSignatureData.create(encodedSignature, timestamp, null);
    }

    public static ISignatureData create(byte[] encodedSignature, ITimestampToken timestamp, IExtendedValidationData validationData) {
        if (timestamp == null && validationData == null) {
            return SignatureData.create(encodedSignature);
        }
        return new ExtendedSignatureData(encodedSignature, timestamp, validationData);
    }

    public static ISignatureData create(byte[] encodedSignature, ITimestampToken timestamp, IX509CRL[] pCrls, IOCSPResponse[] pOcsps, IX509PublicKeyCertificate[] pCertificates) {
        return ExtendedSignatureData.create(encodedSignature, timestamp, new ExtendedValidationData(pCrls, pOcsps, pCertificates));
    }

    protected ExtendedSignatureData(byte[] encodedSignature, ITimestampToken timestamp, IExtendedValidationData validationData) {
        super(encodedSignature);
        this.timestamp = timestamp;
        this.validationData = validationData;
    }

    @Override
    public IExtendedValidationData getExtendedValidationData() {
        return this.validationData;
    }

    @Override
    public ITimestampToken getTimestamp() {
        return this.timestamp;
    }
}

