/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.standard.validation;

import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.ocsp.IOCSPResponse;
import de.intarsys.security.validation.IExtendedValidationData;
import java.util.Arrays;
import java.util.stream.Stream;

public class ExtendedValidationData
implements IExtendedValidationData {
    private final IX509CRL[] crls;
    private final IOCSPResponse[] ocsps;
    private final IX509PublicKeyCertificate[] certificates;

    public ExtendedValidationData(IX509CRL[] pCrls, IOCSPResponse[] pOcsps, IX509PublicKeyCertificate[] pCertificates) {
        assert (pCrls != null);
        assert (pOcsps != null);
        assert (pCertificates != null);
        this.crls = pCrls;
        this.ocsps = pOcsps;
        this.certificates = pCertificates;
    }

    @Override
    public Stream<IX509PublicKeyCertificate> getCertificates() {
        return Arrays.stream(this.certificates);
    }

    @Override
    public Stream<IX509CRL> getCRLs() {
        return Arrays.stream(this.crls);
    }

    @Override
    public Stream<IOCSPResponse> getOCSPResponses() {
        return Arrays.stream(this.ocsps);
    }
}

