/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.standard.validation;

import de.intarsys.security.algorithm.common.AlgorithmSpec;
import de.intarsys.security.standard.validation.CommonValidationState;
import de.intarsys.security.standard.validation.VSModification;
import de.intarsys.security.validation.IChangeProvider;
import de.intarsys.security.validation.IDocumentChange;
import de.intarsys.security.validation.IVSDigest;
import de.intarsys.security.validation.IVSModification;
import de.intarsys.security.validation.IValidationMessage;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.security.validation.IValidationTarget;
import java.util.List;

public class VSDigest
extends CommonValidationState
implements IVSDigest {
    private byte[] referenceDigest;
    private byte[] calculatedDigest;
    private AlgorithmSpec algorithmSpec;
    private IVSModification modificationState;

    public static VSDigest createInvalid(IValidationMessage message) {
        VSDigest state = new VSDigest(3);
        state.addMessage(message);
        return state;
    }

    public static IVSDigest createUnknown(IValidationMessage message) {
        VSDigest state = new VSDigest(2);
        state.addMessage(message);
        return state;
    }

    public static IVSDigest createValid(IValidationMessage message) {
        VSDigest state = new VSDigest(0);
        state.addMessage(message);
        return state;
    }

    public VSDigest() {
        super((IValidationTarget)null);
    }

    public VSDigest(int state) {
        super(null, state);
    }

    public VSDigest(IVSDigest state) {
        super(state);
    }

    @Override
    protected void copy(IValidationState state) {
        super.copy(state);
        IVSDigest digestState = (IVSDigest)state;
        this.algorithmSpec = digestState.getAlgorithmSpec();
        this.calculatedDigest = digestState.getCalculatedDigest();
        this.referenceDigest = digestState.getReferenceDigest();
    }

    @Override
    public AlgorithmSpec getAlgorithmSpec() {
        return this.algorithmSpec;
    }

    @Override
    public byte[] getCalculatedDigest() {
        return this.calculatedDigest;
    }

    @Override
    public int getChangeLevel() {
        return this.getModificationState().getChangeLevel();
    }

    public IChangeProvider getChangeProvider() {
        if (this.getModificationState() instanceof VSModification) {
            return ((VSModification)this.getModificationState()).getChangeProvider();
        }
        return null;
    }

    public IVSModification getModificationState() {
        if (this.modificationState == null) {
            this.modificationState = new VSModification();
        }
        return this.modificationState;
    }

    @Override
    public byte[] getReferenceDigest() {
        return this.referenceDigest;
    }

    @Override
    public List<IDocumentChange> getSubsequentChanges() {
        return this.getModificationState().getSubsequentChanges();
    }

    @Override
    public void merge(IValidationState toMerge) {
        super.merge(toMerge);
        if (!(toMerge instanceof IVSDigest)) {
            return;
        }
        IVSDigest digestState = (IVSDigest)toMerge;
        this.setAlgorithmSpec(digestState.getAlgorithmSpec());
        this.setCalculatedDigest(digestState.getCalculatedDigest());
        this.setReferenceDigest(digestState.getReferenceDigest());
    }

    public void setAlgorithmSpec(AlgorithmSpec algorithmSpec) {
        this.algorithmSpec = algorithmSpec;
    }

    public void setCalculatedDigest(byte[] calculatedDigest) {
        this.calculatedDigest = calculatedDigest;
    }

    public void setModificationState(IVSModification modificationState) {
        this.modificationState = modificationState;
    }

    public void setReferenceDigest(byte[] referenceDigest) {
        this.referenceDigest = referenceDigest;
    }
}

