/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.standard.validation;

import de.intarsys.security.standard.validation.CommonValidationState;
import de.intarsys.security.validation.IChangeProvider;
import de.intarsys.security.validation.IDocumentChange;
import de.intarsys.security.validation.IVSModification;
import de.intarsys.security.validation.IValidationMessage;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.security.validation.IValidationTarget;
import java.io.IOException;
import java.util.List;

public class VSModification
extends CommonValidationState
implements IVSModification {
    private IChangeProvider changeProvider;
    private int changeLevel = -1;

    public static VSModification createInvalid(IValidationMessage message) {
        VSModification state = new VSModification(3);
        state.addMessage(message);
        return state;
    }

    public static IVSModification createUnknown(IValidationMessage message) {
        VSModification state = new VSModification(2);
        state.addMessage(message);
        return state;
    }

    public static IVSModification createValid(IValidationMessage message) {
        VSModification state = new VSModification(0);
        state.addMessage(message);
        return state;
    }

    public VSModification() {
        super((IValidationTarget)null);
    }

    public VSModification(int state) {
        super(null, state);
    }

    @Override
    protected void copy(IValidationState state) {
        super.copy(state);
        IVSModification other = (IVSModification)state;
        this.changeLevel = other.getChangeLevel();
        if (other instanceof VSModification) {
            this.changeProvider = ((VSModification)other).getChangeProvider();
        }
    }

    @Override
    public int getChangeLevel() {
        if (this.changeLevel == -1) {
            if (this.isUndefined()) {
                return -1;
            }
            if (this.isValid()) {
                return 0;
            }
            return 99;
        }
        return this.changeLevel;
    }

    public IChangeProvider getChangeProvider() {
        return this.changeProvider;
    }

    @Override
    public List<IDocumentChange> getSubsequentChanges() {
        if (this.getChangeProvider() != null) {
            try {
                return this.getChangeProvider().getSubsequentChanges();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void increaseChangeLevel(int newLevel) {
        if (newLevel > this.changeLevel) {
            this.changeLevel = newLevel;
        }
    }

    @Override
    public void merge(IValidationState toMerge) {
        super.merge(toMerge);
        if (!(toMerge instanceof IVSModification)) {
            return;
        }
        IVSModification other = (IVSModification)toMerge;
        this.setChangeLevel(other.getChangeLevel());
        if (other instanceof VSModification) {
            this.setChangeProvider(((VSModification)other).getChangeProvider());
        }
    }

    public void setChangeLevel(int changeLevel) {
        this.changeLevel = changeLevel;
    }

    public void setChangeProvider(IChangeProvider changeProvider) {
        this.changeProvider = changeProvider;
    }
}

