/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.standard.validation;

import de.intarsys.security.standard.validation.CommonValidationState;
import de.intarsys.security.standard.validation.DefaultValidationTarget;
import de.intarsys.security.standard.validation.VSMathematicalSignature;
import de.intarsys.security.validation.IVSDigest;
import de.intarsys.security.validation.IVSMathematicalSignature;
import de.intarsys.security.validation.IVSSignature;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.security.validation.IValidationTarget;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.string.PrettyPrinter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class VSSignature
extends CommonValidationState
implements IVSSignature {
    private List<IVSDigest> digestStates;
    private IVSMathematicalSignature signatureState;

    public VSSignature(IDigest calculatedDigest) {
        super(calculatedDigest == null ? null : new DefaultValidationTarget(calculatedDigest));
    }

    public VSSignature(IDigest calculatedDigest, int state) {
        super((IValidationTarget)(calculatedDigest == null ? null : new DefaultValidationTarget(calculatedDigest)), state);
    }

    public VSSignature(IVSSignature state) {
        super(state);
    }

    public void addDigestState(IVSDigest pDigestState) {
        if (pDigestState == null) {
            return;
        }
        this.addDigestStates(new IVSDigest[]{pDigestState});
    }

    public void addDigestStates(IVSDigest[] pDigestStates) {
        if (pDigestStates == null || pDigestStates.length == 0) {
            return;
        }
        if (this.digestStates == null) {
            this.digestStates = new ArrayList<IVSDigest>(pDigestStates.length);
        }
        for (IVSDigest digestState : pDigestStates) {
            this.digestStates.add(digestState);
            this.increaseState(digestState);
        }
    }

    @Override
    protected void copy(IValidationState state) {
        super.copy(state);
        VSSignature sigState = (VSSignature)state;
        if (sigState.digestStates != null) {
            this.digestStates = new ArrayList<IVSDigest>(sigState.digestStates);
        }
        this.signatureState = sigState.signatureState;
    }

    @Override
    public List<IVSDigest> getDigestStates() {
        if (this.digestStates == null) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList<IVSDigest>(this.digestStates);
    }

    @Override
    public IVSMathematicalSignature getSignatureState() {
        if (this.signatureState == null) {
            this.signatureState = new VSMathematicalSignature();
        }
        return this.signatureState;
    }

    public void removeDigestState(IVSDigest pDigestState) {
        if (pDigestState != null && this.digestStates != null) {
            this.digestStates.remove(pDigestState);
        }
    }

    public void removeDigestStates() {
        this.digestStates = null;
    }

    public void setSignatureState(IVSMathematicalSignature signatureState) {
        this.signatureState = signatureState;
        this.increaseState(signatureState);
    }

    @Override
    public void toString(PrettyPrinter printer) {
        super.toString(printer);
        printer.appendMember("digestStates", this.getDigestStates(), null);
        printer.appendMember("signatureState", (Object)this.getSignatureState(), null);
    }
}

