/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.standard.validation.commonpki;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;

public class CryptoDates {
    public static final Date EXPIRATIONDATE_SIG_DIGEST_SHA1 = new GregorianCalendar(2008, 6, 1).getTime();
    public static final Date EXPIRATIONDATE_SIG_DIGEST_RIPEMD160 = new GregorianCalendar(2011, 0, 1).getTime();
    public static final Date EXPIRATIONDATE_CERTCREATE_DIGEST_SHA1 = new GregorianCalendar(2010, 0, 1).getTime();
    public static final Date EXPIRATIONDATE_CERTCREATE_DIGEST_SHA1_EXT = new GregorianCalendar(2011, 0, 1).getTime();
    public static final Date EXPIRATIONDATE_CERTVALIDATE_DIGEST_SHA1 = new GregorianCalendar(2016, 0, 1).getTime();
    public static final Date EXPIRATIONDATE_CERTVALIDATE_DIGEST_RIPEMD160 = new GregorianCalendar(2016, 0, 1).getTime();
    public static final Date EXPIRATIONDATE_SIG_DIGEST_SHA224 = new GregorianCalendar(2026, 0, 1).getTime();
    public static final Date EXPIRATIONDATE_SIG_RSA_1024_1279 = new GregorianCalendar(2008, 3, 1).getTime();
    public static final Date EXPIRATIONDATE_SIG_RSA_1280_1535 = new GregorianCalendar(2009, 0, 1).getTime();
    public static final Date EXPIRATIONDATE_SIG_RSA_1536_1727 = new GregorianCalendar(2010, 0, 1).getTime();
    public static final Date EXPIRATIONDATE_SIG_RSA_1728_1899 = new GregorianCalendar(2011, 0, 1).getTime();
    public static final Date EXPIRATIONDATE_SIG_RSA_1900_2999 = new GregorianCalendar(2026, 0, 1).getTime();
    public static final Date EXPIRATIONDATE_SIG_RSA_PKCS1_v1_5 = new GregorianCalendar(2026, 0, 1).getTime();
    public static final Date EXPIRATIONDATE_SIG_ECDSA_QPARAM_160 = new GregorianCalendar(2008, 0, 1).getTime();
    public static final Date EXPIRATIONDATE_SIG_ECDSA_QPARAM_180 = new GregorianCalendar(2010, 0, 1).getTime();
    public static final Date EXPIRATIONDATE_SIG_ECDSA_QPARAM_224 = new GregorianCalendar(2016, 0, 1).getTime();
    private static final Date EXPIRATIONDATE_UNKNOWN = new GregorianCalendar(2029, 0, 1).getTime();
    public static final Date END_OF_SIGG = new GregorianCalendar(2017, 6, 29).getTime();
    private static final Map<String, Date> digestAlgorithmExpiration = new HashMap<String, Date>(10);

    public static Date getExpirationDateForDigestAlgorithm(String digestAlgorithm) {
        Date expirationDate = digestAlgorithmExpiration.get(digestAlgorithm);
        if (expirationDate == null) {
            expirationDate = EXPIRATIONDATE_UNKNOWN;
        }
        return expirationDate;
    }

    public static Date getExpirationDateForECDSAKeySize(int bitSizeQParam) {
        if (bitSizeQParam <= 179) {
            return EXPIRATIONDATE_SIG_ECDSA_QPARAM_160;
        }
        if (bitSizeQParam <= 223) {
            return EXPIRATIONDATE_SIG_ECDSA_QPARAM_180;
        }
        if (bitSizeQParam <= 249) {
            return EXPIRATIONDATE_SIG_ECDSA_QPARAM_224;
        }
        return EXPIRATIONDATE_UNKNOWN;
    }

    public static Date getExpirationDateForRSAKeySize(int bitKeySize) {
        if (bitKeySize < 1280) {
            return EXPIRATIONDATE_SIG_RSA_1024_1279;
        }
        if (bitKeySize < 1536) {
            return EXPIRATIONDATE_SIG_RSA_1280_1535;
        }
        if (bitKeySize < 1728) {
            return EXPIRATIONDATE_SIG_RSA_1536_1727;
        }
        if (bitKeySize < 1900) {
            return EXPIRATIONDATE_SIG_RSA_1728_1899;
        }
        if (bitKeySize < 3000) {
            return EXPIRATIONDATE_SIG_RSA_1900_2999;
        }
        return EXPIRATIONDATE_UNKNOWN;
    }

    public static LocalDate getExpirationForDigestAlgorithm(String digestAlgorithm) {
        Date date = CryptoDates.getExpirationDateForDigestAlgorithm(digestAlgorithm);
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDate getExpirationForECDSAKeySize(int bitSizeQParam) {
        Date date = CryptoDates.getExpirationDateForECDSAKeySize(bitSizeQParam);
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDate getExpirationForRSAKeySize(int bitKeySize) {
        Date date = CryptoDates.getExpirationDateForRSAKeySize(bitKeySize);
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).toLocalDate();
    }

    static {
        digestAlgorithmExpiration.put("SHA-1", EXPIRATIONDATE_SIG_DIGEST_SHA1);
        digestAlgorithmExpiration.put("RIPEMD160", EXPIRATIONDATE_SIG_DIGEST_RIPEMD160);
        digestAlgorithmExpiration.put("SHA-224", EXPIRATIONDATE_SIG_DIGEST_SHA224);
        digestAlgorithmExpiration.put("SHA-256", EXPIRATIONDATE_UNKNOWN);
        digestAlgorithmExpiration.put("SHA-384", EXPIRATIONDATE_UNKNOWN);
        digestAlgorithmExpiration.put("SHA-512", EXPIRATIONDATE_UNKNOWN);
        digestAlgorithmExpiration.put("RIPEMD256", EXPIRATIONDATE_UNKNOWN);
    }
}

