/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tools;

import de.intarsys.tools.file.WildcardMatch;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;

public class X500NameWildcardMatcher {
    private static WildcardMatch WildcardMatch = new WildcardMatch();
    private Map<ASN1ObjectIdentifier, Set<ASN1Encodable>> expectedTypesAndValues;

    private static Map<ASN1ObjectIdentifier, Set<ASN1Encodable>> collectTypesAndValues(RDN[] rdns) {
        HashMap<ASN1ObjectIdentifier, Set<ASN1Encodable>> map = new HashMap<ASN1ObjectIdentifier, Set<ASN1Encodable>>();
        Arrays.stream(rdns).flatMap(rdn -> Arrays.stream(rdn.getTypesAndValues())).forEach(typeAndValue -> {
            ASN1ObjectIdentifier type = typeAndValue.getType();
            HashSet<ASN1Encodable> set = (HashSet<ASN1Encodable>)map.get(type);
            if (set == null) {
                set = new HashSet<ASN1Encodable>();
                map.put(type, set);
            }
            set.add(typeAndValue.getValue());
        });
        return map;
    }

    private static Map<ASN1ObjectIdentifier, Set<ASN1Encodable>> collectTypesAndValues(X500Name x500Name) {
        return X500NameWildcardMatcher.collectTypesAndValues(x500Name.getRDNs());
    }

    public X500NameWildcardMatcher(Map<ASN1ObjectIdentifier, Set<ASN1Encodable>> expectedTypesAndValues) {
        this.expectedTypesAndValues = expectedTypesAndValues;
    }

    public X500NameWildcardMatcher(RDN[] expectedTypesAndValues) {
        this(X500NameWildcardMatcher.collectTypesAndValues(expectedTypesAndValues));
    }

    public X500NameWildcardMatcher(X500Name expectedTypesAndValues) {
        this(X500NameWildcardMatcher.collectTypesAndValues(expectedTypesAndValues));
    }

    protected boolean hasMatchingValue(Set<ASN1Encodable> candidateValues, ASN1Encodable expectedValue) {
        return candidateValues.stream().anyMatch(candidateValue -> this.matchesValue((ASN1Encodable)candidateValue, expectedValue));
    }

    public boolean matches(X500Name candidate) {
        Map<ASN1ObjectIdentifier, Set<ASN1Encodable>> candidateTypesAndValues = X500NameWildcardMatcher.collectTypesAndValues(candidate);
        return this.expectedTypesAndValues.entrySet().stream().allMatch(expectedTypeAndValue -> this.matchesValues((Set)candidateTypesAndValues.get(expectedTypeAndValue.getKey()), (Set)expectedTypeAndValue.getValue()));
    }

    protected boolean matchesValue(ASN1Encodable candidateValue, ASN1Encodable expectedValue) {
        return WildcardMatch.match(expectedValue.toString(), candidateValue.toString());
    }

    protected boolean matchesValues(Set<ASN1Encodable> candidateValues, Set<ASN1Encodable> expectedValues) {
        return expectedValues.stream().allMatch(expectedValue -> this.hasMatchingValue(candidateValues, (ASN1Encodable)expectedValue));
    }
}

