/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.crypto.cryptdec;

import de.intarsys.tools.crypto.CryptoEnvironment;
import de.intarsys.tools.crypto.GenericCryptdecFactory;
import de.intarsys.tools.crypto.ICryptdecFactory;
import de.intarsys.tools.crypto.api.IByteProvider;
import de.intarsys.tools.exception.InitializationException;
import jakarta.annotation.PostConstruct;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class CryptdecFactoryInstaller {
    private String id;
    private boolean defaultFactory = false;
    private String algorithmId = "AES";
    private IByteProvider keyProvider;

    public String getAlgorithmId() {
        return this.algorithmId;
    }

    public String getId() {
        return this.id;
    }

    public IByteProvider getKeyProvider() {
        return this.keyProvider;
    }

    @PostConstruct
    public void install() {
        try {
            SecretKeySpec key = new SecretKeySpec(this.getKeyProvider().getBytes(), this.getAlgorithmId());
            GenericCryptdecFactory f = new GenericCryptdecFactory(this.id, (SecretKey)key);
            CryptoEnvironment.get().registerCryptdecFactory((ICryptdecFactory)f);
            if (this.isDefaultFactory()) {
                CryptoEnvironment.get().setDefaultCryptdecFactoryEncrypt((ICryptdecFactory)f);
            }
        }
        catch (Exception e) {
            throw new InitializationException("cannot install CryptdecFactory '" + this.getId() + "'", (Throwable)e);
        }
    }

    public boolean isDefaultFactory() {
        return this.defaultFactory;
    }

    public void setAlgorithmId(String algorithmId) {
        this.algorithmId = algorithmId;
    }

    public void setDefaultFactory(boolean defaultFactory) {
        this.defaultFactory = defaultFactory;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setKeyProvider(IByteProvider keyProvider) {
        this.keyProvider = keyProvider;
    }
}

