/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdfium;

import de.intarsys.nativec.PseudoObject;
import de.intarsys.nativec.type.INativeObject;
import de.intarsys.pdfium.FpdfPage;
import de.intarsys.pdfium.Fpdfview;
import de.intarsys.pdfium.nativec.FPDF_BITMAP;

public class FpdfBitmap
extends PseudoObject<FPDF_BITMAP>
implements AutoCloseable {
    public FpdfBitmap(FPDF_BITMAP nativeBitmap) {
        super((INativeObject)nativeBitmap);
    }

    @Override
    public void close() {
        this.destroy();
    }

    public void destroy() {
        Fpdfview.destroyBitmap(this);
    }

    public void fillRect(int width, int height, int color) {
        Fpdfview.fillBitmapRect(this, width, height, color);
    }

    public byte[] getBuffer() {
        int size = this.getStride() * this.getHeight();
        return Fpdfview.getBitmapBuffer(this, size);
    }

    private int getHeight() {
        return Fpdfview.getBitmapHeight(this);
    }

    public int getStride() {
        return Fpdfview.getBitmapStride(this);
    }

    public void renderPage(FpdfPage page, int startX, int startY, int sizeX, int sizeY) {
        Fpdfview.renderPage(this, page, startX, startY, sizeX, sizeY, 0);
    }

    public void renderPage(FpdfPage page, int startX, int startY, int sizeX, int sizeY, int flags) {
        Fpdfview.renderPage(this, page, startX, startY, sizeX, sizeY, flags);
    }
}

