/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdfium;

import de.intarsys.nativec.Opaque;
import de.intarsys.nativec.api.CLong;
import de.intarsys.nativec.api.CallbackAdapter;
import de.intarsys.nativec.api.INativeFunction;
import de.intarsys.nativec.type.NativeBuffer;
import de.intarsys.nativec.type.NativeString;
import de.intarsys.nativec.type.NativeVoid;
import de.intarsys.pdfium.FontObject;
import de.intarsys.pdfium.FpdfSysfontinfoObject;
import de.intarsys.pdfium.nativec.FPDF_SYSFONTINFO;
import de.intarsys.pdfium.nativec.FpdfSysfontinfoFunctions;
import java.util.HashMap;
import java.util.Map;

public class FpdfSysfontinfo {
    private static Map<Long, FontObject> FontObjects = new HashMap<Long, FontObject>();
    private static FpdfSysfontinfoObject SysfontinfoObject;

    public static void addInstalledFont(Opaque mapper, String face, int charset) {
        FpdfSysfontinfoFunctions.FpdfSysfontinfoNI.FPDF_AddInstalledFont((NativeVoid)mapper.getNativeObject(), face, charset);
    }

    public static void setSystemFontInfo(FpdfSysfontinfoObject sysfontinfoObject) {
        SysfontinfoObject = sysfontinfoObject;
        FpdfSysfontinfoFunctions.FpdfSysfontinfoNI.FPDF_SetSystemFontInfo((FPDF_SYSFONTINFO)sysfontinfoObject.getNativeObject());
    }

    public static abstract class GetFontDataAdapter
    extends CallbackAdapter {
        public Object getCallingConvention() {
            return INativeFunction.CallingConventionCdecl;
        }

        public Class<?>[] getParameterTypes() {
            return new Class[]{FPDF_SYSFONTINFO.class, NativeVoid.class, Integer.class, NativeBuffer.class, CLong.class};
        }

        public Class<?> getReturnType() {
            return CLong.class;
        }

        protected abstract long invoke(FontObject var1, int var2, byte[] var3);

        public Object invoke(Object[] objects) {
            NativeVoid nativeFont = (NativeVoid)objects[1];
            long address = nativeFont.getNativeHandle().getAddress();
            FontObject fontObject = FontObjects.get(address);
            int table = (Integer)objects[2];
            NativeBuffer nativeBuffer = (NativeBuffer)objects[3];
            int size = ((CLong)objects[4]).intValue();
            byte[] buffer = nativeBuffer == null ? null : new byte[size];
            long returnValue = this.invoke(fontObject, table, buffer);
            if (nativeBuffer != null) {
                nativeBuffer.setByteArray(0, buffer, 0, size);
            }
            return new CLong(returnValue);
        }
    }

    public static abstract class GetFontAdapter
    extends CallbackAdapter {
        public Object getCallingConvention() {
            return INativeFunction.CallingConventionCdecl;
        }

        public Class<?>[] getParameterTypes() {
            return new Class[]{FPDF_SYSFONTINFO.class, NativeString.class};
        }

        public Class<?> getReturnType() {
            return NativeVoid.class;
        }

        public Object invoke(Object[] objects) {
            NativeString nativeFace = (NativeString)objects[1];
            FontObject fontObject = this.invoke(nativeFace.stringValue());
            FontObjects.put(((NativeVoid)fontObject.getNativeObject()).getNativeHandle().getAddress(), fontObject);
            return fontObject.getNativeObject();
        }

        protected abstract FontObject invoke(String var1);
    }

    public static abstract class EnumFontsAdapter
    extends CallbackAdapter {
        public Object getCallingConvention() {
            return INativeFunction.CallingConventionCdecl;
        }

        public Class<?>[] getParameterTypes() {
            return new Class[]{FPDF_SYSFONTINFO.class, NativeVoid.class};
        }

        public Class<?> getReturnType() {
            return Void.class;
        }

        public Object invoke(Object[] objects) {
            NativeVoid nativeMapper = (NativeVoid)objects[1];
            this.invoke(new Opaque(nativeMapper));
            return null;
        }

        protected abstract void invoke(Opaque var1);
    }

    public static abstract class DeleteFontAdapter
    extends CallbackAdapter {
        public Object getCallingConvention() {
            return INativeFunction.CallingConventionCdecl;
        }

        public Class<?>[] getParameterTypes() {
            return new Class[]{FPDF_SYSFONTINFO.class, NativeVoid.class};
        }

        public Class<?> getReturnType() {
            return Void.class;
        }

        protected abstract void invoke(FontObject var1);

        public Object invoke(Object[] objects) {
            NativeVoid nativeFont = (NativeVoid)objects[1];
            long address = nativeFont.getNativeHandle().getAddress();
            FontObject fontObject = FontObjects.get(address);
            this.invoke(fontObject);
            FontObjects.remove(address);
            return null;
        }
    }
}

