/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdfium;

import de.intarsys.cwt.font.FontRegistry;
import de.intarsys.cwt.font.IFont;
import de.intarsys.cwt.font.truetype.TTException;
import de.intarsys.cwt.font.truetype.TTFont;
import de.intarsys.cwt.font.truetype.TTTable;
import de.intarsys.nativec.Opaque;
import de.intarsys.nativec.PseudoObject;
import de.intarsys.nativec.type.INativeObject;
import de.intarsys.pdfium.FontObject;
import de.intarsys.pdfium.FpdfSysfontinfo;
import de.intarsys.pdfium.nativec.FPDF_SYSFONTINFO;
import de.intarsys.tools.function.Throwing;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;
import java.math.BigInteger;

public class FpdfSysfontinfoObject
extends PseudoObject<FPDF_SYSFONTINFO> {
    private DeleteFont deleteFont;
    private EnumFonts enumFonts;
    private GetFont getFont;
    private GetFontData getFontData;

    public FpdfSysfontinfoObject() {
        super((INativeObject)new FPDF_SYSFONTINFO());
        ((FPDF_SYSFONTINFO)this.getNativeObject()).setVersion(1);
        this.enumFonts = new EnumFonts();
        ((FPDF_SYSFONTINFO)this.getNativeObject()).setEnumFonts(this.enumFonts.getNativeCallback());
        this.getFont = new GetFont();
        ((FPDF_SYSFONTINFO)this.getNativeObject()).setGetFont(this.getFont.getNativeCallback());
        this.getFontData = new GetFontData();
        ((FPDF_SYSFONTINFO)this.getNativeObject()).setGetFontData(this.getFontData.getNativeCallback());
        this.deleteFont = new DeleteFont();
        ((FPDF_SYSFONTINFO)this.getNativeObject()).setDeleteFont(this.deleteFont.getNativeCallback());
    }

    public DeleteFont getDeleteFont() {
        return this.deleteFont;
    }

    public EnumFonts getEnumFonts() {
        return this.enumFonts;
    }

    public GetFont getGetFont() {
        return this.getFont;
    }

    public GetFontData getGetFontData() {
        return this.getFontData;
    }

    public class EnumFonts
    extends FpdfSysfontinfo.EnumFontsAdapter {
        @Override
        protected void invoke(Opaque mapper) {
            for (IFont font : FontRegistry.get().getFonts()) {
                if (!"TrueType".equals(font.getFontType())) continue;
                FpdfSysfontinfo.addInstalledFont(mapper, font.getFontNamePostScript(), 1);
            }
        }
    }

    public class GetFont
    extends FpdfSysfontinfo.GetFontAdapter {
        @Override
        protected FontObject invoke(String face) {
            return new FontObject(face);
        }
    }

    public class GetFontData
    extends FpdfSysfontinfo.GetFontDataAdapter {
        @Override
        protected long invoke(FontObject fontObject, int table, byte[] buffer) {
            for (IFont font : FontRegistry.get().getFonts()) {
                if (!fontObject.getFace().equals(font.getFontNamePostScript())) continue;
                try {
                    Throwing.Specific.Supplier supplier;
                    long length;
                    ILocator locator = font.getFontProgram().getLocator();
                    if (table == 0) {
                        length = locator.getLength();
                        supplier = () -> locator.getRandomAccess();
                    } else {
                        String tag;
                        TTFont ttFont = TTFont.createFromLocator((ILocator)locator);
                        TTTable ttTable = ttFont.getTable(tag = new String(BigInteger.valueOf(table).toByteArray()));
                        if (ttTable == null) {
                            return 0L;
                        }
                        length = ttTable.getLength();
                        supplier = () -> ttTable.getRandomAccess();
                    }
                    if (buffer != null && (long)buffer.length >= length) {
                        IRandomAccess randomAccess = (IRandomAccess)supplier.get();
                        randomAccess.read(buffer);
                    }
                    return length;
                }
                catch (TTException | IOException ex) {
                    return 0L;
                }
            }
            return 0L;
        }
    }

    public class DeleteFont
    extends FpdfSysfontinfo.DeleteFontAdapter {
        @Override
        protected void invoke(FontObject fontObject) {
        }
    }
}

