/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdfium;

import de.intarsys.nativec.api.CLong;
import de.intarsys.nativec.api.CallbackAdapter;
import de.intarsys.nativec.api.INativeFunction;
import de.intarsys.nativec.type.NativeBuffer;
import de.intarsys.nativec.type.NativeVoid;
import de.intarsys.pdfium.FpdfBitmap;
import de.intarsys.pdfium.FpdfDocument;
import de.intarsys.pdfium.FpdfPage;
import de.intarsys.pdfium.FpdfSysfontinfo;
import de.intarsys.pdfium.FpdfSysfontinfoObject;
import de.intarsys.pdfium.PdfiumException;
import de.intarsys.pdfium.nativec.FPDF_BITMAP;
import de.intarsys.pdfium.nativec.FPDF_DOCUMENT;
import de.intarsys.pdfium.nativec.FPDF_FILEACCESS;
import de.intarsys.pdfium.nativec.FPDF_LIBRARY_CONFIG;
import de.intarsys.pdfium.nativec.FPDF_PAGE;
import de.intarsys.pdfium.nativec.FS_RECTF;
import de.intarsys.pdfium.nativec.FpdfviewFunctions;
import de.intarsys.tools.system.SystemTools;
import java.awt.geom.Rectangle2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fpdfview {
    private static final Logger Log = LoggerFactory.getLogger(Fpdfview.class);

    public static void closeDocument(FpdfDocument document) {
        FpdfviewFunctions.FpdfviewNI.FPDF_CloseDocument((FPDF_DOCUMENT)document.getNativeObject());
    }

    public static void closePage(FpdfPage page) {
        FpdfviewFunctions.FpdfviewNI.FPDF_ClosePage((FPDF_PAGE)page.getNativeObject());
    }

    public static FpdfBitmap createBitmap(int width, int height) throws PdfiumException {
        FPDF_BITMAP nativeBitmap = FpdfviewFunctions.FpdfviewNI.FPDFBitmap_Create(width, height, 0);
        if (nativeBitmap == null) {
            throw new PdfiumException();
        }
        return new FpdfBitmap(nativeBitmap);
    }

    public static FpdfBitmap createBitmap(int width, int height, int format) throws PdfiumException {
        FPDF_BITMAP nativeBitmap = FpdfviewFunctions.FpdfviewNI.FPDFBitmap_CreateEx(width, height, format, null, 0);
        if (nativeBitmap == null) {
            throw new PdfiumException();
        }
        return new FpdfBitmap(nativeBitmap);
    }

    public static void destroyBitmap(FpdfBitmap bitmap) {
        FpdfviewFunctions.FpdfviewNI.FPDFBitmap_Destroy((FPDF_BITMAP)bitmap.getNativeObject());
    }

    public static void fillBitmapRect(FpdfBitmap bitmap, int width, int height, int color) {
        FpdfviewFunctions.FpdfviewNI.FPDFBitmap_FillRect((FPDF_BITMAP)bitmap.getNativeObject(), 0, 0, width, height, color);
    }

    public static byte[] getBitmapBuffer(FpdfBitmap bitmap, int size) {
        FPDF_BITMAP nativeBuffer = FpdfviewFunctions.FpdfviewNI.FPDFBitmap_GetBuffer((FPDF_BITMAP)bitmap.getNativeObject());
        return nativeBuffer.getNativeHandle().getByteArray(0, size);
    }

    public static int getBitmapHeight(FpdfBitmap bitmap) {
        return FpdfviewFunctions.FpdfviewNI.FPDFBitmap_GetHeight((FPDF_BITMAP)bitmap.getNativeObject());
    }

    public static int getBitmapStride(FpdfBitmap bitmap) {
        return FpdfviewFunctions.FpdfviewNI.FPDFBitmap_GetStride((FPDF_BITMAP)bitmap.getNativeObject());
    }

    public static int getBitmapWidth(FpdfBitmap bitmap) {
        return FpdfviewFunctions.FpdfviewNI.FPDFBitmap_GetWidth((FPDF_BITMAP)bitmap.getNativeObject());
    }

    public static int getDocumentPageCount(FpdfDocument document) {
        return FpdfviewFunctions.FpdfviewNI.FPDF_GetPageCount((FPDF_DOCUMENT)document.getNativeObject());
    }

    public static int getLastError() {
        return FpdfviewFunctions.FpdfviewNI.FPDF_GetLastError();
    }

    public static Rectangle2D.Float getPageBoundingBox(FpdfPage page) throws PdfiumException {
        FS_RECTF nativeRect = new FS_RECTF();
        boolean result = FpdfviewFunctions.FpdfviewNI.FPDF_GetPageBoundingBox((FPDF_PAGE)page.getNativeObject(), nativeRect);
        if (!result) {
            throw new PdfiumException();
        }
        float left = nativeRect.getLeft();
        float bottom = nativeRect.getBottom();
        return new Rectangle2D.Float(left, bottom, nativeRect.getRight() - left, nativeRect.getTop() - bottom);
    }

    public static double getPageHeight(FpdfPage page) {
        return FpdfviewFunctions.FpdfviewNI.FPDF_GetPageHeight((FPDF_PAGE)page.getNativeObject());
    }

    public static double getPageWidth(FpdfPage page) {
        return FpdfviewFunctions.FpdfviewNI.FPDF_GetPageWidth((FPDF_PAGE)page.getNativeObject());
    }

    public static void initLibrary() {
        FPDF_LIBRARY_CONFIG nativeConfig = new FPDF_LIBRARY_CONFIG();
        nativeConfig.setVersion(2);
        FpdfviewFunctions.FpdfviewNI.FPDF_InitLibraryWithConfig(nativeConfig);
    }

    public static FpdfDocument loadDocument(final byte[] bytes, String password) throws PdfiumException {
        GetBlockAdapter getBlock = new GetBlockAdapter(){

            @Override
            protected void invoke(long position, byte[] buffer) throws Exception {
                System.arraycopy(bytes, (int)position, buffer, 0, buffer.length);
            }
        };
        return Fpdfview.loadDocument(bytes.length, getBlock, password);
    }

    public static FpdfDocument loadDocument(long fileLen, GetBlockAdapter getBlock, String password) throws PdfiumException {
        FPDF_FILEACCESS fileAccess = new FPDF_FILEACCESS();
        fileAccess.setFileLen(fileLen);
        fileAccess.setGetBlock(getBlock.getNativeCallback());
        FPDF_DOCUMENT nativeDocument = FpdfviewFunctions.FpdfviewNI.FPDF_LoadCustomDocument(fileAccess, password);
        if (nativeDocument == null) {
            throw new PdfiumException();
        }
        return new FpdfDocument(nativeDocument);
    }

    public static FpdfDocument loadDocument(String filePath, String password) throws PdfiumException {
        FPDF_DOCUMENT nativeDocument = FpdfviewFunctions.FpdfviewNI.FPDF_LoadDocument(filePath, password);
        if (nativeDocument == null) {
            throw new PdfiumException();
        }
        return new FpdfDocument(nativeDocument);
    }

    public static FpdfPage loadPage(FpdfDocument document, int index) throws PdfiumException {
        FPDF_PAGE nativePage = FpdfviewFunctions.FpdfviewNI.FPDF_LoadPage((FPDF_DOCUMENT)document.getNativeObject(), index);
        if (nativePage == null) {
            throw new PdfiumException();
        }
        return new FpdfPage(nativePage);
    }

    public static void renderPage(FpdfBitmap bitmap, FpdfPage page, int startX, int startY, int sizeX, int sizeY, int flags) {
        FpdfviewFunctions.FpdfviewNI.FPDF_RenderPageBitmap((FPDF_BITMAP)bitmap.getNativeObject(), (FPDF_PAGE)page.getNativeObject(), startX, startY, sizeX, sizeY, 0, flags);
    }

    static {
        Fpdfview.initLibrary();
        if (SystemTools.isLinux()) {
            FpdfSysfontinfo.setSystemFontInfo(new FpdfSysfontinfoObject());
        }
    }

    public static abstract class GetBlockAdapter
    extends CallbackAdapter {
        public Object getCallingConvention() {
            return INativeFunction.CallingConventionCdecl;
        }

        public Class<?>[] getParameterTypes() {
            return new Class[]{NativeVoid.class, CLong.class, NativeBuffer.class, CLong.class};
        }

        public Class<?> getReturnType() {
            return Integer.class;
        }

        protected abstract void invoke(long var1, byte[] var3) throws Exception;

        public Object invoke(Object[] objects) {
            long position = ((CLong)objects[1]).longValue();
            NativeBuffer nativeBuffer = (NativeBuffer)objects[2];
            int size = ((CLong)objects[3]).intValue();
            try {
                byte[] buffer = new byte[size];
                this.invoke(position, buffer);
                nativeBuffer.setByteArray(0, buffer, 0, size);
            }
            catch (Exception ex) {
                Log.error(ex.getMessage(), (Throwable)ex);
                return 0;
            }
            return -1;
        }
    }
}

