/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdfium.nativec;

import de.intarsys.nativec.api.INativeFunction;
import de.intarsys.nativec.api.INativeLibrary;
import de.intarsys.nativec.api.NativeInterface;
import de.intarsys.tools.installresource.InstallFile;
import de.intarsys.tools.system.SystemTools;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibPdfium {
    private static INativeLibrary Lib;
    private static final Logger Log;

    public static INativeLibrary getLib() {
        if (Lib == null) {
            InstallFile install = new InstallFile("de/intarsys/pdfium/nativec", System.mapLibraryName("pdfium"), true);
            try {
                install.load();
            }
            catch (IOException ex) {
                Log.warn(ex.getMessage(), (Throwable)ex);
            }
            Lib = NativeInterface.get().createLibrary(install.getFile().getAbsolutePath(), SystemTools.isWindows() ? INativeFunction.CallingConventionStdcall : INativeFunction.CallingConventionCdecl);
        }
        return Lib;
    }

    static {
        Log = LoggerFactory.getLogger(LibPdfium.class);
    }
}

