/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.jna;

import com.sun.jna.CallbackProxy;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.WString;
import de.intarsys.nativec.api.CLong;
import de.intarsys.nativec.api.CWideString;
import de.intarsys.nativec.api.ICallback;
import de.intarsys.nativec.api.INativeCallback;
import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.jna.IJnaNativeCallback;
import de.intarsys.nativec.jna.JnaNativeHandle;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeObject;
import de.intarsys.nativec.type.NativeType;
import java.util.Arrays;
import java.util.List;

public abstract class JnaNativeCallback
implements IJnaNativeCallback,
INativeCallback,
CallbackProxy {
    private ICallback callback;
    private INativeHandle nativeHandle;

    public static Class<?> translateType(Class<?> type) {
        if (CWideString.class.isAssignableFrom(type)) {
            return WString.class;
        }
        if (CLong.class.isAssignableFrom(type)) {
            return NativeLong.class;
        }
        if (NativeObject.class.isAssignableFrom(type)) {
            return Pointer.class;
        }
        if (INativeHandle.class.isAssignableFrom(type)) {
            return Pointer.class;
        }
        return type;
    }

    public JnaNativeCallback(ICallback pCallback) {
        this.callback = pCallback;
    }

    @Override
    public Object callback(Object[] args) {
        for (int index = 0; index < args.length; ++index) {
            Pointer pointer;
            Object object;
            Class parameterType = this.callback.getParameterTypes()[index];
            if (CWideString.class.isAssignableFrom(parameterType)) {
                WString wstring = (WString)args[index];
                object = new CWideString(wstring.toString());
            } else if (CLong.class.isAssignableFrom(parameterType)) {
                Number nativeNumber = (Number)args[index];
                object = new CLong(nativeNumber.longValue());
            } else if (NativeObject.class.isAssignableFrom(parameterType)) {
                pointer = (Pointer)args[index];
                if (pointer == null) {
                    object = null;
                } else {
                    JnaNativeHandle handle = new JnaNativeHandle(pointer);
                    INativeType type = NativeType.lookup((Class)parameterType);
                    if (type == null) {
                        throw new IllegalArgumentException("no type for '" + parameterType + "'");
                    }
                    object = type.createNative((INativeHandle)handle);
                }
            } else {
                object = INativeHandle.class.isAssignableFrom(parameterType) ? ((pointer = (Pointer)args[index]) == null ? null : new JnaNativeHandle(pointer)) : args[index];
            }
            args[index] = object;
        }
        Class returnType = this.callback.getReturnType();
        Object returnValue = this.callback.invoke(args);
        if (CLong.class.isAssignableFrom(returnType)) {
            if (Native.LONG_SIZE == 8) {
                return ((CLong)returnValue).longValue();
            }
            return ((CLong)returnValue).intValue();
        }
        if (NativeObject.class.isAssignableFrom(returnType)) {
            NativeObject nativeObject = (NativeObject)returnValue;
            return ((JnaNativeHandle)nativeObject.getNativeHandle()).getPointer();
        }
        return returnValue;
    }

    public INativeHandle getNativeHandle() {
        if (this.nativeHandle == null) {
            Memory pointer = new Memory((long)Native.POINTER_SIZE);
            DummyStructure dummyStructure = new DummyStructure((Pointer)pointer);
            dummyStructure.writeField("callback", this);
            this.nativeHandle = new JnaNativeHandle(pointer.getPointer(0L));
        }
        return this.nativeHandle;
    }

    public Class<?>[] getParameterTypes() {
        Class[] genericParameterTypes = this.callback.getParameterTypes();
        Class[] nativeParameterTypes = new Class[genericParameterTypes.length];
        for (int index = 0; index < genericParameterTypes.length; ++index) {
            nativeParameterTypes[index] = JnaNativeCallback.translateType(genericParameterTypes[index]);
        }
        return nativeParameterTypes;
    }

    public Class<?> getReturnType() {
        return JnaNativeCallback.translateType(this.callback.getReturnType());
    }

    public static class DummyStructure
    extends Structure {
        public IJnaNativeCallback callback;

        public DummyStructure(Pointer pointer) {
            super(pointer);
        }

        protected List<String> getFieldOrder() {
            return Arrays.asList("callback");
        }
    }
}

