/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.jna;

import com.sun.jna.Function;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import de.intarsys.nativec.api.ICallback;
import de.intarsys.nativec.api.INativeCallback;
import de.intarsys.nativec.api.INativeFunction;
import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.INativeInterface;
import de.intarsys.nativec.api.INativeLibrary;
import de.intarsys.nativec.jna.JnaNativeCallbackAlt;
import de.intarsys.nativec.jna.JnaNativeCallbackStd;
import de.intarsys.nativec.jna.JnaNativeFunction;
import de.intarsys.nativec.jna.JnaNativeHandle;
import de.intarsys.nativec.jna.JnaNativeLibrary;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JnaNativeInterface
implements INativeInterface {
    private List<String> searchPaths = new ArrayList<String>();

    public void addSearchPath(String path) {
        if (this.searchPaths.contains(path)) {
            return;
        }
        this.searchPaths.add(path);
    }

    public INativeHandle allocate(int size) {
        return new JnaNativeHandle(this.createMemory(size));
    }

    public INativeCallback createCallback(ICallback callback) {
        if (callback == null) {
            return null;
        }
        if (callback.getCallingConvention() == INativeFunction.CallingConventionStdcall) {
            return new JnaNativeCallbackAlt(callback);
        }
        if (callback.getCallingConvention() == INativeFunction.CallingConventionCdecl) {
            return new JnaNativeCallbackStd(callback);
        }
        throw new IllegalArgumentException("illegal calling convention");
    }

    public INativeFunction createFunction(long address) {
        return this.createFunction(address, INativeFunction.CallingConventionCdecl);
    }

    public INativeFunction createFunction(long address, Object callingConvention) {
        int callFlags;
        if (callingConvention == INativeFunction.CallingConventionCdecl) {
            callFlags = 0;
        } else if (callingConvention == INativeFunction.CallingConventionStdcall) {
            callFlags = 63;
        } else {
            throw new IllegalArgumentException("illegal calling convention");
        }
        Pointer pointer = new Pointer(address);
        Function function = Function.getFunction((Pointer)pointer, (int)callFlags);
        return new JnaNativeFunction(function);
    }

    public INativeHandle createHandle(long address) {
        return new JnaNativeHandle(address);
    }

    public INativeLibrary createLibrary(String name) {
        return this.createLibrary(name, INativeFunction.CallingConventionCdecl);
    }

    public INativeLibrary createLibrary(String name, Object callingConvention) {
        try {
            HashMap<String, Object> options = new HashMap<String, Object>(2);
            if (callingConvention == INativeFunction.CallingConventionCdecl) {
                options.put("calling-convention", 0);
            } else if (callingConvention == INativeFunction.CallingConventionStdcall) {
                options.put("calling-convention", 63);
            } else {
                throw new IllegalArgumentException("illegal calling convention");
            }
            options.put("open-flags", -1);
            return new JnaNativeLibrary(this, name, options);
        }
        catch (Throwable t) {
            Logger.getLogger("nativec").log(Level.FINEST, "JNA error creating library '" + name + "' (" + t.getMessage() + ")");
            throw t;
        }
    }

    protected Pointer createMemory(int size) {
        try {
            Memory p = new Memory((long)size);
            p.clear((long)size);
            return p;
        }
        catch (Exception e) {
            throw new InternalError("can not create Pointer");
        }
    }

    protected List<String> getSearchPaths() {
        return this.searchPaths;
    }

    public int longSize() {
        return Native.LONG_SIZE;
    }

    public int pointerSize() {
        return Native.POINTER_SIZE;
    }

    public String toString(byte[] bytes) {
        return Native.toString((byte[])bytes);
    }

    public int wideCharSize() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        ClassLoader loader;
        System.setProperty("jna.encoding", Charset.defaultCharset().name());
        ClassLoader classLoader = loader = JnaNativeInterface.class.getClassLoader();
        synchronized (classLoader) {
            try {
                Class.forName("com.sun.jna.Native", true, loader);
            }
            catch (Exception e) {
                throw new InternalError("can not load JNA", e);
            }
        }
    }
}

