/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.adapter;

import de.intarsys.cwt.environment.IGraphicsEnvironment;
import de.intarsys.pdf.platform.cwt.adapter.IGraphicsEnvironmentAdapter;
import de.intarsys.pdf.platform.cwt.adapter.IGraphicsEnvironmentAdapterRegistry;
import de.intarsys.tools.provider.ProviderTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class StandardGraphicsEnvironmentAdapterRegistry
implements IGraphicsEnvironmentAdapterRegistry {
    private boolean lookupProviders = true;
    private Map<IGraphicsEnvironment, IGraphicsEnvironmentAdapter> adapters = new HashMap<IGraphicsEnvironment, IGraphicsEnvironmentAdapter>();
    private boolean initialized = false;

    protected IGraphicsEnvironmentAdapter[] findProviders() {
        Iterator ps = ProviderTools.providers(IGraphicsEnvironmentAdapter.class);
        ArrayList<IGraphicsEnvironmentAdapter> adapters = new ArrayList<IGraphicsEnvironmentAdapter>();
        while (ps.hasNext()) {
            adapters.add((IGraphicsEnvironmentAdapter)ps.next());
        }
        return adapters.toArray(new IGraphicsEnvironmentAdapter[adapters.size()]);
    }

    protected void init() {
        if (!this.lookupProviders || this.initialized) {
            return;
        }
        this.initialized = true;
        IGraphicsEnvironmentAdapter[] adapters = this.findProviders();
        for (int i = 0; i < adapters.length; ++i) {
            this.registerGraphicsEnvironmentAdapter(adapters[i].getGraphicsEnvironment(), adapters[i]);
        }
    }

    public boolean isLookupProviders() {
        return this.lookupProviders;
    }

    @Override
    public synchronized IGraphicsEnvironmentAdapter lookupGraphicsEnvironmentAdapter(IGraphicsEnvironment environment) {
        this.init();
        IGraphicsEnvironmentAdapter adapter = this.adapters.get(environment);
        return adapter;
    }

    @Override
    public synchronized void registerGraphicsEnvironmentAdapter(IGraphicsEnvironment environment, IGraphicsEnvironmentAdapter adapter) {
        this.adapters.put(environment, adapter);
    }

    public void setLookupProviders(boolean pLookupProviders) {
        this.lookupProviders = pLookupProviders;
    }
}

