/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.environment;

import de.intarsys.cwt.common.IPaint;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.cwt.environment.IGraphicsEnvironment;
import de.intarsys.cwt.image.IImage;
import de.intarsys.cwt.image.ImageConvertOption;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.platform.cwt.image.IPlatformImage;
import de.intarsys.tools.exception.UnreachableCodeError;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;

public class PdfGraphicsContext
implements IGraphicsContext {
    private static final int SEGMENT_SIZE = 6;
    private AffineTransform coordinatesTransform;
    private final CSCreator csCreator;
    private Color foregroundColor;
    private Color backgroundColor;

    public PdfGraphicsContext(CSCreator csCreator) {
        this(csCreator, new AffineTransform());
    }

    public PdfGraphicsContext(CSCreator csCreator, AffineTransform coordinatesTransform) {
        this.csCreator = csCreator;
        this.coordinatesTransform = coordinatesTransform;
    }

    public void clip(Shape shape) {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        throw new UnsupportedOperationException();
    }

    public void draw(Shape s) {
        this.path(s);
        this.csCreator.pathStroke();
    }

    public void drawImage(IImage image, float x, float y) {
        Point2D.Float dest = new Point2D.Float();
        this.coordinatesTransform.transform(new Point2D.Float(x, y), dest);
        ((IPlatformImage)image.asImage(IPlatformImage.class, new ImageConvertOption[0])).drawContentStream(this.csCreator, (float)((Point2D)dest).getX(), (float)((Point2D)dest).getY());
    }

    public void drawString(String text, float x, float y) {
        throw new UnsupportedOperationException();
    }

    public void fill(Shape s) {
        Path2D path;
        this.path(s);
        this.csCreator.pathClose();
        if (s instanceof Path2D && (path = (Path2D)s).getWindingRule() == 0) {
            this.csCreator.pathFillEvenOdd();
        } else {
            this.csCreator.pathFillNonZero();
        }
    }

    public void fillDraw(Shape s) {
        Path2D path;
        this.path(s);
        this.csCreator.pathClose();
        if (s instanceof Path2D && (path = (Path2D)s).getWindingRule() == 0) {
            this.csCreator.pathFillStrokeEvenOdd();
        } else {
            this.csCreator.pathFillStrokeNonZero();
        }
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Shape getClip() {
        throw new UnsupportedOperationException();
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public IGraphicsEnvironment getGraphicsEnvironment() {
        throw new UnsupportedOperationException();
    }

    public RenderingHints getRenderingHints() {
        throw new UnsupportedOperationException();
    }

    public AffineTransform getTransform() {
        throw new UnsupportedOperationException();
    }

    protected void path(Shape s) {
        if (s instanceof Rectangle2D) {
            this.csCreator.penRectangle(this.coordinatesTransform.createTransformedShape(s).getBounds2D());
            return;
        }
        PathIterator pathIterator = s.getPathIterator(this.coordinatesTransform);
        float[] coords = new float[6];
        while (!pathIterator.isDone()) {
            int type = pathIterator.currentSegment(coords);
            switch (type) {
                case 0: {
                    this.csCreator.penMoveTo(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    this.csCreator.penLineTo(coords[0], coords[1]);
                    break;
                }
                case 3: {
                    this.csCreator.penCurveToC(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 2: {
                    this.csCreator.penCurveToC(coords[0], coords[1], coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 4: {
                    if (pathIterator.isDone()) break;
                    this.csCreator.pathClose();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            pathIterator.next();
        }
    }

    public void rotate(float theta) {
        throw new UnsupportedOperationException();
    }

    public void scale(float x, float y) {
        throw new UnsupportedOperationException();
    }

    public void setBackgroundColor(Color c) {
        this.backgroundColor = c;
        if (c == null) {
            return;
        }
        int rgb = c.getRGB();
        this.csCreator.setNonStrokeColorRGB((float)((rgb & 0xFF0000) >> 16) / 255.0f, (float)((rgb & 0xFF00) >> 8) / 255.0f, (float)(rgb & 0xFF) / 255.0f);
    }

    public void setBackgroundPaint(IPaint paint) {
        throw new UnsupportedOperationException();
    }

    public void setClip(Shape shape) {
        throw new UnsupportedOperationException();
    }

    public void setFont(Font font) {
        throw new UnsupportedOperationException();
    }

    public void setForegroundColor(Color c) {
        this.foregroundColor = c;
        if (c == null) {
            return;
        }
        int rgb = c.getRGB();
        this.csCreator.setStrokeColorRGB((float)((rgb & 0xFF0000) >> 16) / 255.0f, (float)((rgb & 0xFF00) >> 8) / 255.0f, (float)(rgb & 0xFF) / 255.0f);
    }

    public void setForegroundPaint(IPaint paint) {
        throw new UnsupportedOperationException();
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        throw new UnsupportedOperationException();
    }

    public void setRenderingHints(Map hints) {
        throw new UnsupportedOperationException();
    }

    public void setStroke(Stroke s) {
        if (!(s instanceof BasicStroke)) {
            throw new UnsupportedOperationException();
        }
        BasicStroke basicStroke = (BasicStroke)s;
        float lineWidth = basicStroke.getLineWidth();
        this.csCreator.setLineWidth(lineWidth);
        int endCap = basicStroke.getEndCap();
        switch (endCap) {
            case 0: {
                this.csCreator.setLineCap(0);
                break;
            }
            case 1: {
                this.csCreator.setLineCap(1);
                break;
            }
            case 2: {
                this.csCreator.setLineCap(2);
                break;
            }
            default: {
                throw new UnreachableCodeError();
            }
        }
        int lineJoin = basicStroke.getLineJoin();
        switch (lineJoin) {
            case 0: {
                this.csCreator.setLineJoin(0);
                break;
            }
            case 1: {
                this.csCreator.setLineJoin(1);
                break;
            }
            case 2: {
                this.csCreator.setLineJoin(2);
                break;
            }
            default: {
                throw new UnreachableCodeError();
            }
        }
    }

    public void setTransform(AffineTransform transform) {
        throw new UnsupportedOperationException();
    }

    public void transform(AffineTransform transform) {
        throw new UnsupportedOperationException();
    }

    public void translate(float x, float y) {
        throw new UnsupportedOperationException();
    }
}

