/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.font;

import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.ICOSDocumentListener;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontTools;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.platform.cwt.font.StandardFontFactory;
import java.util.List;

public class DocumentFontFactory
extends StandardFontFactory {
    private final PDDocument doc;
    private ICOSDocumentListener listenDocumentChange = new ICOSDocumentListener(){

        public void changed(COSDocument document, Object slot, Object oldValue, Object newValue) {
            if (slot == COSDocument.SLOT_ALL) {
                DocumentFontFactory.this.reset();
            }
        }
    };

    protected DocumentFontFactory(PDDocument doc) {
        this.doc = doc;
        doc.cosGetDoc().addDocumentListener(this.listenDocumentChange);
        this.readFonts();
    }

    public PDDocument getDoc() {
        return this.doc;
    }

    protected void readFonts() {
        List fonts = PDFontTools.getFonts((PDDocument)this.getDoc());
        for (PDFont font : fonts) {
            if (!this.isReusable(font)) continue;
            this.registerFont(font);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.readFonts();
    }
}

