/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.font;

import de.intarsys.cwt.font.IFont;
import de.intarsys.cwt.font.truetype.TTException;
import de.intarsys.cwt.font.truetype.TTFont;
import de.intarsys.cwt.font.truetype.TTPostScriptInformation;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontDescriptorEmbedded;
import de.intarsys.pdf.font.PDFontTrueType;
import de.intarsys.pdf.font.outlet.FontFactoryException;
import de.intarsys.pdf.platform.cwt.font.FontConverterPlatform2Pdf;
import de.intarsys.pdf.platform.cwt.font.PDFontTrueTypeTools;
import de.intarsys.tools.locator.ILocator;
import java.io.IOException;

public class FontConverterTrueType2Pdf
extends FontConverterPlatform2Pdf {
    public FontConverterTrueType2Pdf(IFont font) {
        super(font);
    }

    @Override
    protected PDFont basicCreatePdFont() throws FontFactoryException {
        return (PDFontTrueType)PDFontTrueType.META.createNew();
    }

    @Override
    protected void embedFontFile(ILocator locator) throws FontFactoryException {
        try {
            PDFontTrueTypeTools.embedFontFile(this.getPdFont(), locator);
        }
        catch (IOException e) {
            throw new FontFactoryException((Throwable)e);
        }
    }

    @Override
    protected void fillFontDescriptor() throws FontFactoryException {
        super.fillFontDescriptor();
        PDFontDescriptorEmbedded fontDescriptor = (PDFontDescriptorEmbedded)this.getPdFont().getFontDescriptor();
        TTFont ttFont = PDFontTrueTypeTools.getTTFont(this.getPdFont());
        float italicAngle = 0.0f;
        if (ttFont != null) {
            try {
                TTPostScriptInformation post = ttFont.getPostScriptInformation();
                if (post != null) {
                    italicAngle = post.getItalicAngle();
                }
            }
            catch (TTException tTException) {
                // empty catch block
            }
        }
        fontDescriptor.setItalicAngle(italicAngle);
        fontDescriptor.setStemV(0);
    }
}

