/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.font;

import de.intarsys.cwt.font.truetype.CreateSubset;
import de.intarsys.cwt.font.truetype.TTCMap;
import de.intarsys.cwt.font.truetype.TTCharacterToGlyphIndexMapping;
import de.intarsys.cwt.font.truetype.TTException;
import de.intarsys.cwt.font.truetype.TTFont;
import de.intarsys.cwt.font.truetype.TTFontSerializer;
import de.intarsys.pdf.font.CIDFont;
import de.intarsys.pdf.font.CIDFontType2;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.font.PDFontDescriptorEmbedded;
import de.intarsys.pdf.font.PDFontTrueType;
import de.intarsys.pdf.font.PDFontType0;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.platform.cwt.font.PlatformFontTools;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;

public class PDFontTrueTypeTools {
    private static final Attribute ATTR_CWTFONT = new Attribute("cwtfont");

    protected static TTFont basicSubset(PDFont pdFont, TTFont ttFont, Set<Integer> indices) throws IOException {
        TTFont newFont;
        CreateSubset tool = new CreateSubset(ttFont, indices);
        try {
            newFont = tool.compute();
        }
        catch (TTException e) {
            newFont = ttFont;
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            new TTFontSerializer().write((OutputStream)bos, newFont);
            pdFont.getFontDescriptor().setFontFile2(bos.toByteArray());
        }
        return newFont;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected static void embedFontFile(PDFont font, ILocator locator) throws IOException {
        InputStream is = locator.getInputStream();
        try {
            byte[] data = StreamTools.toByteArray((InputStream)is);
            ((PDFontDescriptorEmbedded)font.getFontDescriptor()).setFontFile2(data);
        }
        finally {
            StreamTools.close((Closeable)is);
        }
        if (font instanceof PDFontTrueType) {
            PDFontTrueTypeTools.subset(font);
        }
    }

    public static TTFont getTTFont(PDFont pdFont) {
        TTFont ttFont = (TTFont)pdFont.getAttribute((Object)ATTR_CWTFONT);
        if (ttFont != null) {
            return ttFont;
        }
        ILocator locator = PlatformFontTools.getFontFile(pdFont);
        if (locator == null) {
            return null;
        }
        try {
            ttFont = TTFont.createFromLocator((ILocator)locator);
            PDFontTrueTypeTools.setTTFont(pdFont, ttFont);
            return ttFont;
        }
        catch (TTException | IOException e) {
            return null;
        }
    }

    protected static TTCMap getTTFontCMap(PDFont pdFont) throws TTException {
        TTFont ttFont = PDFontTrueTypeTools.getTTFont(pdFont);
        TTCMap result = null;
        PDFontDescriptor fontDescriptor = null;
        try {
            fontDescriptor = pdFont.getFontDescriptor();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        TTCharacterToGlyphIndexMapping mapping = ttFont.getCharacterToGlyphIndexMapping();
        result = fontDescriptor == null ? mapping.getCMap(3, 1) : (fontDescriptor.isSymbolic() ? mapping.getCMap(3, 0) : mapping.getCMap(3, 1));
        if (result == null) {
            throw new TTException("No suitable CMap found");
        }
        return result;
    }

    public static boolean isTrueTypeBased(PDFont pdFont) {
        if (pdFont instanceof PDFontTrueType) {
            return true;
        }
        if (pdFont instanceof PDFontType0) {
            CIDFont cidFont = ((PDFontType0)pdFont).getDescendantFont();
            return cidFont instanceof CIDFontType2;
        }
        return false;
    }

    public static void setTTFont(PDFont pdFont, TTFont ttFont) {
        pdFont.setAttribute((Object)ATTR_CWTFONT, (Object)ttFont);
    }

    @Deprecated
    public static void subset(PDFont pdFont) throws IOException {
        if (!PDFontTrueTypeTools.isTrueTypeBased(pdFont)) {
            throw new IllegalArgumentException("subsetting " + pdFont.getClass().getName() + " not supported");
        }
        TTFont ttFont = PDFontTrueTypeTools.getTTFont(pdFont);
        TTCMap cmap = null;
        try {
            cmap = PDFontTrueTypeTools.getTTFontCMap(pdFont);
        }
        catch (TTException e) {
            return;
        }
        HashSet<Integer> indices = new HashSet<Integer>();
        int first = pdFont.getFirstChar();
        int last = pdFont.getLastChar();
        for (int i = first; i <= last; ++i) {
            int decoded = pdFont.getEncoding().getDecoded(i);
            indices.add(cmap.getGlyphId(decoded));
        }
        TTFont newFont = PDFontTrueTypeTools.basicSubset(pdFont, ttFont, indices);
        PDFontTrueTypeTools.setTTFont(pdFont, newFont);
    }

    public static void subset(PDFont pdFont, Set<PDGlyphs> used) throws IOException {
        if (!PDFontTrueTypeTools.isTrueTypeBased(pdFont)) {
            throw new IllegalArgumentException("subsetting " + pdFont.getClass().getName() + " not supported");
        }
        TTFont ttFont = PDFontTrueTypeTools.getTTFont(pdFont);
        TTCMap cmap = null;
        try {
            cmap = PDFontTrueTypeTools.getTTFontCMap(pdFont);
        }
        catch (TTException e) {
            return;
        }
        HashSet<Integer> indices = new HashSet<Integer>();
        for (PDGlyphs pdGlyphs : used) {
            if (pdFont instanceof PDFontType0) {
                indices.add(pdGlyphs.getCodepoint());
                continue;
            }
            int decoded = pdGlyphs.getDecoded();
            indices.add(cmap.getGlyphId(decoded));
        }
        TTFont newFont = PDFontTrueTypeTools.basicSubset(pdFont, ttFont, indices);
        PDFontTrueTypeTools.setTTFont(pdFont, newFont);
    }
}

