/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.font;

import de.intarsys.cwt.font.afm.AFM;
import de.intarsys.cwt.font.type1.PFB;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.font.PDFontDescriptorEmbedded;
import de.intarsys.pdf.font.PDFontType1;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.font.outlet.FontFactoryException;
import de.intarsys.pdf.platform.cwt.font.IPlatformFont;
import de.intarsys.pdf.platform.cwt.font.IPlatformGlyphs;
import de.intarsys.pdf.platform.cwt.font.PlatformFontException;
import de.intarsys.pdf.platform.cwt.font.PlatformFontFactory;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;

public class PDFontType1Tools {
    protected static PDFontDescriptorEmbedded createFontDescriptorEmbedded(PDFont pdFont) throws FontFactoryException {
        AFM afm = PDFontType1.lookupBuiltinAFM((String)pdFont.getFontName());
        PDFontDescriptorEmbedded result = (PDFontDescriptorEmbedded)PDFontDescriptorEmbedded.META.createNew();
        String fontBBox = null;
        String italicAngle = null;
        String ascent = null;
        String descend = null;
        String capheight = null;
        String stemV = null;
        boolean symbolic = false;
        if (afm != null) {
            fontBBox = afm.getAttribute("FontBBox");
            italicAngle = afm.getAttribute("ItalicAngle");
            ascent = afm.getAttribute("Ascender");
            descend = afm.getAttribute("Descender");
            capheight = afm.getAttribute("CapHeight");
            stemV = afm.getAttribute("StdVW");
            symbolic = afm.getAttribute("CharacterSet").equals("Special");
        }
        if (fontBBox == null) {
            fontBBox = "0 0 0 0";
        }
        if (italicAngle == null) {
            italicAngle = "0";
        }
        if (ascent == null) {
            ascent = "0";
        }
        if (descend == null) {
            descend = "0";
        }
        if (capheight == null) {
            capheight = "0";
        }
        if (stemV == null) {
            stemV = "0";
        }
        StringTokenizer tokens = new StringTokenizer(fontBBox);
        String a = tokens.nextToken();
        String b = tokens.nextToken();
        String c = tokens.nextToken();
        String d = tokens.nextToken();
        result.setFontName(pdFont.getFontName());
        result.setFontBB(new CDSRectangle((float)Integer.parseInt(a), (float)Integer.parseInt(b), (float)Integer.parseInt(c), (float)Integer.parseInt(d)));
        result.setItalicAngle(Float.parseFloat(italicAngle));
        result.setAscent(Integer.parseInt(ascent));
        result.setDescent(Integer.parseInt(descend));
        result.setCapHeight(Integer.parseInt(capheight));
        result.setStemV(Integer.parseInt(stemV));
        result.setFlags(0);
        result.getFlags().setSymbolic(symbolic);
        try {
            int start = pdFont.getFirstChar();
            int stop = pdFont.getLastChar();
            COSArray fontWidths = COSArray.create((int)(stop - start + 1));
            IPlatformFont pfFont = PlatformFontFactory.get().createPlatformFont(pdFont);
            for (int i = start; i <= stop; ++i) {
                PDGlyphs pdglyphs = pdFont.getGlyphsEncoded(i);
                IPlatformGlyphs pfglyphs = pfFont.createPlatformGlyphs(pdglyphs);
                fontWidths.add(i - start, (COSObject)COSInteger.create((int)pfglyphs.getWidth()));
            }
            pdFont.cosSetField(PDFont.DK_Widths, (COSObject)fontWidths);
            pdFont.cosSetField(PDFont.DK_FirstChar, (COSObject)COSInteger.create((int)start));
            pdFont.cosSetField(PDFont.DK_LastChar, (COSObject)COSInteger.create((int)stop));
        }
        catch (PlatformFontException e) {
            throw new FontFactoryException(e.getMessage());
        }
        return result;
    }

    protected static void embedFontFile(PDFont pdFont, ILocator locator) throws IOException {
        if (pdFont.getFontDescriptor().isBuiltin()) {
            try {
                pdFont.setFontDescriptor((PDFontDescriptor)PDFontType1Tools.createFontDescriptorEmbedded(pdFont));
            }
            catch (FontFactoryException e) {
                throw new IOException(e.getMessage());
            }
        }
        try (InputStream is = locator.getInputStream();){
            byte[] data = StreamTools.toByteArray((InputStream)is);
            PFB pfb = PFB.from((byte[])data);
            pdFont.getFontDescriptor().setFontFile(pfb.getStrippedData());
        }
        catch (IllegalArgumentException exception) {
            throw new IOException("malformed font file", exception);
        }
    }

    public static boolean isType1Based(PDFont pdFont) {
        return pdFont instanceof PDFontType1;
    }
}

