/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.font;

import de.intarsys.cwt.font.FontStyle;
import de.intarsys.cwt.font.FontTools;
import de.intarsys.cwt.font.IFont;
import de.intarsys.cwt.font.IFontQuery;
import de.intarsys.pdf.encoding.Encoding;
import de.intarsys.pdf.encoding.WinAnsiEncoding;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontStyle;
import de.intarsys.pdf.font.PDFontType1;
import de.intarsys.pdf.font.outlet.FontFactoryException;
import de.intarsys.pdf.font.outlet.FontQuery;
import de.intarsys.pdf.font.outlet.IFontFactory;
import de.intarsys.pdf.platform.cwt.font.FontConverterCwt2Pdf;
import de.intarsys.pdf.platform.cwt.font.PlatformFontTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardFontFactory
implements IFontFactory {
    private static final Logger Log = LoggerFactory.getLogger(StandardFontFactory.class);
    private static final String BUILTIN_SUFFIX_BOLD = "-Bold";
    private static final String BUILTIN_SUFFIX_BOLDOBLIQUE = "-BoldOblique";
    private static final String BUILTIN_SUFFIX_OBLIQUE = "-Oblique";
    private final List cache = new ArrayList(10);
    private boolean embedNew = true;

    protected PDFont createBuiltinFontAlias(de.intarsys.pdf.font.outlet.IFontQuery query) {
        String builtinName = this.createBuiltinName(query);
        if (!PDFontType1.isBuiltinAlias((String)builtinName)) {
            return null;
        }
        return PDFontType1.createNew((String)builtinName);
    }

    protected PDFont createBuiltinFontStandard(de.intarsys.pdf.font.outlet.IFontQuery query) {
        String builtinName = this.createBuiltinName(query);
        if (!PDFontType1.isBuiltin((String)builtinName)) {
            return null;
        }
        return PDFontType1.createNew((String)builtinName);
    }

    protected String createBuiltinName(de.intarsys.pdf.font.outlet.IFontQuery query) {
        String fontName = query.getFontName();
        if (fontName != null) {
            return fontName;
        }
        String family = query.getFontFamilyName();
        if ("Courier".equals(family) || "Helvetica".equals(family)) {
            PDFontStyle style = query.getFontStyle();
            if (style == PDFontStyle.BOLD) {
                return family + BUILTIN_SUFFIX_BOLD;
            }
            if (style == PDFontStyle.ITALIC) {
                return family + BUILTIN_SUFFIX_OBLIQUE;
            }
            if (style == PDFontStyle.BOLD_ITALIC) {
                return family + BUILTIN_SUFFIX_BOLDOBLIQUE;
            }
        } else if ("Times-Roman".equals(family)) {
            PDFontStyle style = query.getFontStyle();
            if (style == PDFontStyle.BOLD) {
                return "Times-Bold";
            }
            if (style == PDFontStyle.ITALIC) {
                return "Times-Italic";
            }
            if (style == PDFontStyle.BOLD_ITALIC) {
                return "Times-BoldItalic";
            }
        }
        return family;
    }

    protected PDFont createExternalFont(de.intarsys.pdf.font.outlet.IFontQuery query) throws FontFactoryException {
        de.intarsys.cwt.font.FontQuery cwtQuery = new de.intarsys.cwt.font.FontQuery();
        cwtQuery.setFontType(query.getFontType());
        cwtQuery.setFontName(query.getFontName());
        cwtQuery.setFontFamilyName(query.getFontFamilyName());
        cwtQuery.setFontStyle(FontStyle.getFontStyle((String)query.getFontStyle().getLabel()));
        IFont font = FontTools.lookupFont((IFontQuery)cwtQuery);
        if (font != null) {
            Log.trace("StandardFontFactory external font {} loaded for {}", (Object)font, (Object)query);
            FontConverterCwt2Pdf converter = new FontConverterCwt2Pdf(font);
            converter.setEmbed(this.isEmbedNew());
            return converter.getPdFont();
        }
        Log.trace("StandardFontFactory external font load failed for {}", (Object)query);
        return null;
    }

    public PDFont getBoldFlavor(PDFont font) throws FontFactoryException {
        PDFontStyle style = font.getLookupFontStyle().getBoldFlavor();
        FontQuery template = new FontQuery(font);
        template.setOverrideFontStyle(style);
        PDFont result = this.lookupFont((de.intarsys.pdf.font.outlet.IFontQuery)template);
        if (result == null) {
            result = this.loadFont((de.intarsys.pdf.font.outlet.IFontQuery)template);
        }
        return result == null ? font : result;
    }

    protected List getCache() {
        return this.cache;
    }

    public PDFont getFont(de.intarsys.pdf.font.outlet.IFontQuery query) throws FontFactoryException {
        PDFont result = this.lookupFont(query);
        if (result == null) {
            result = this.loadFont(query);
        }
        if (result == null) {
            throw new FontFactoryException("can't find font");
        }
        return result;
    }

    public PDFont getItalicFlavor(PDFont font) throws FontFactoryException {
        PDFont result = null;
        PDFontStyle style = font.getLookupFontStyle().getItalicFlavor();
        FontQuery template = new FontQuery(font);
        template.setOverrideFontStyle(style);
        result = this.lookupFont((de.intarsys.pdf.font.outlet.IFontQuery)template);
        if (result == null) {
            result = this.loadFont((de.intarsys.pdf.font.outlet.IFontQuery)template);
        }
        return result == null ? font : result;
    }

    public PDFont getRegularFlavor(PDFont font) throws FontFactoryException {
        PDFont result = null;
        PDFontStyle style = PDFontStyle.REGULAR;
        FontQuery template = new FontQuery(font);
        template.setOverrideFontStyle(style);
        result = this.lookupFont((de.intarsys.pdf.font.outlet.IFontQuery)template);
        if (result == null) {
            result = this.loadFont((de.intarsys.pdf.font.outlet.IFontQuery)template);
        }
        return result == null ? font : result;
    }

    public boolean isEmbedNew() {
        return this.embedNew;
    }

    protected boolean isReusable(PDFont font) {
        if (font.isStandardFont()) {
            return true;
        }
        if (font.isSubset()) {
            return false;
        }
        Encoding encoding = font.getEncoding();
        for (int i = font.getFirstChar(); i < font.getLastChar(); ++i) {
            if (encoding.getDecoded(i) != -1) continue;
            return false;
        }
        return true;
    }

    protected PDFont loadFont(de.intarsys.pdf.font.outlet.IFontQuery query) throws FontFactoryException {
        PDFont result = null;
        if ("Builtin".equals(query.getFontType())) {
            result = this.createBuiltinFontAlias(query);
        } else if ("Type1".equals(query.getFontType())) {
            result = this.createBuiltinFontAlias(query);
            if (result == null) {
                result = this.createExternalFont(query);
            }
        } else if ("TrueType".equals(query.getFontType())) {
            result = this.createExternalFont(query);
        } else {
            result = this.createBuiltinFontStandard(query);
            if (result == null && (result = this.createExternalFont(query)) == null) {
                result = this.createBuiltinFontAlias(query);
            }
        }
        if (result != null) {
            if (query.getEncoding() != null) {
                result.setEncoding(query.getEncoding());
            } else if (result.getFontDescriptor().isNonsymbolic()) {
                result.setEncoding((Encoding)WinAnsiEncoding.UNIQUE);
            }
            if (this.isEmbedNew()) {
                try {
                    PlatformFontTools.embedFontFile(result);
                }
                catch (IOException e) {
                    throw new FontFactoryException((Throwable)e);
                }
            }
            if (query.getFontName() != null) {
                if (result.getBaseFont() == null) {
                    result.setBaseFont(query.getFontName());
                    result.getFontDescriptor().setFontName(result.getFontName());
                }
                result.setLookupFontName(query.getFontName());
            }
            if (query.getFontFamilyName() != null) {
                result.setLookupFontFamilyName(query.getFontFamilyName());
            }
            if (query.getFontStyle() != PDFontStyle.UNDEFINED) {
                result.setLookupFontStyle(query.getFontStyle());
            }
            this.registerFont(result);
        } else {
            Log.trace("StandardFontFactory cant load {}", (Object)query);
        }
        return result;
    }

    protected PDFont lookupFont(de.intarsys.pdf.font.outlet.IFontQuery query) {
        for (PDFont font : this.getCache()) {
            if (!this.matches(query, font)) continue;
            Log.trace("StandardFontFactory cache hit for {}", (Object)query);
            return font;
        }
        return null;
    }

    protected boolean matches(de.intarsys.pdf.font.outlet.IFontQuery query, PDFont font) {
        if (query.getFontType() != null && !"Any".equals(query.getFontType()) && !query.getFontType().equals(font.getFontType())) {
            return false;
        }
        if (query.getFontName() != null) {
            if (!query.getFontName().equals(font.getLookupFontName())) {
                return false;
            }
        } else {
            if (query.getFontFamilyName() != null && !query.getFontFamilyName().equals(font.getLookupFontFamilyName())) {
                return false;
            }
            if (query.getFontStyle() != PDFontStyle.UNDEFINED && font.getLookupFontStyle() != query.getFontStyle()) {
                return false;
            }
        }
        return query.getEncoding() == null || font.getEncoding() == query.getEncoding();
    }

    public void registerFont(PDFont font) {
        this.getCache().add(font);
    }

    public void reset() {
        this.cache.clear();
    }

    public void setEmbedNew(boolean embedNew) {
        this.embedNew = embedNew;
    }

    protected FontStyle toFontStyle(PDFontStyle pdFontStyle) {
        return FontStyle.getFontStyle((String)pdFontStyle.getLabel());
    }
}

