/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.image;

import de.intarsys.pdf.pd.PDCSDeviceGray;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.image.CwtPlatformImage;

public class ColorKeyMaskImage
extends CwtPlatformImage {
    protected static byte[] createMaskBytes(PDImage basePdImage, byte[] baseBytes, int[] maskArray) {
        int width = basePdImage.getWidth();
        int height = basePdImage.getHeight();
        int numComponents = basePdImage.getColorSpace().getNumComponents();
        byte[] resultBytes = new byte[width * height];
        int scanline = width * numComponents;
        for (int y = 0; y < height; ++y) {
            int baseOffset = y * scanline;
            int componentIndex = 0;
            int pixelIndex = 0;
            for (int byteIndex = 0; byteIndex < width * numComponents; ++byteIndex) {
                byte value = baseBytes[baseOffset + byteIndex];
                int lower = maskArray[componentIndex * 2];
                int upper = maskArray[componentIndex * 2 + 1];
                if (value < lower || value > upper) {
                    resultBytes[y * width + pixelIndex] = -1;
                }
                if (++componentIndex != numComponents) continue;
                componentIndex = 0;
                ++pixelIndex;
            }
        }
        return resultBytes;
    }

    protected static byte[] createMaskBytes(PDImage basePdImage, int[] maskArray) {
        int width = basePdImage.getWidth();
        int height = basePdImage.getHeight();
        int numComponents = basePdImage.getColorSpace().getNumComponents();
        int bitsPerComponent = basePdImage.getBitsPerComponent();
        int bitMask = (int)Math.pow(2.0, bitsPerComponent) - 1;
        byte[] baseBytes = basePdImage.cosGetStream().getDecodedBytes();
        byte[] resultBytes = new byte[width * height];
        int scanline = (width * numComponents * bitsPerComponent + 7) / 8;
        int componentsPerByte = 8 / bitsPerComponent;
        for (int y = 0; y < height; ++y) {
            int baseOffset = y * scanline;
            int componentIndex = 0;
            int pixelIndex = 0;
            for (int byteIndex = 0; byteIndex < width * numComponents / componentsPerByte; ++byteIndex) {
                byte value = baseBytes[baseOffset + byteIndex];
                for (int bitIndex = 0; bitIndex < 8; bitIndex += bitsPerComponent) {
                    int componentValue = value >> 8 - bitsPerComponent - bitIndex & bitMask;
                    int lower = maskArray[componentIndex * 2];
                    int upper = maskArray[componentIndex * 2 + 1];
                    if (componentValue < lower || componentValue > upper) {
                        resultBytes[y * width + pixelIndex] = -1;
                    }
                    if (++componentIndex != numComponents) continue;
                    componentIndex = 0;
                    ++pixelIndex;
                }
            }
            if (width * numComponents % componentsPerByte == 0) continue;
            byte value = baseBytes[baseOffset + scanline - 1];
            for (int bitIndex = 0; bitIndex < width * numComponents % componentsPerByte * bitsPerComponent; bitIndex += bitsPerComponent) {
                int componentValue = value >> 8 - bitsPerComponent - bitIndex & bitMask;
                int lower = maskArray[componentIndex * 2];
                int upper = maskArray[componentIndex * 2 + 1];
                if (componentValue < lower || componentValue > upper) {
                    resultBytes[y * width + pixelIndex] = -1;
                }
                if (++componentIndex != numComponents) continue;
                componentIndex = 0;
                ++pixelIndex;
            }
        }
        return resultBytes;
    }

    protected static PDImage createPdImage(PDImage basePdImage, byte[] eightBpcBytes, int[] maskArray) {
        PDImage pdImage = (PDImage)PDImage.META.createNew();
        pdImage.setWidth(basePdImage.getWidth());
        pdImage.setHeight(basePdImage.getHeight());
        pdImage.setBitsPerComponent(8);
        byte[] maskBytes = eightBpcBytes == null || eightBpcBytes.length != basePdImage.getWidth() * basePdImage.getHeight() * basePdImage.getColorSpace().getNumComponents() ? ColorKeyMaskImage.createMaskBytes(basePdImage, maskArray) : ColorKeyMaskImage.createMaskBytes(basePdImage, eightBpcBytes, maskArray);
        pdImage.setBytes(maskBytes);
        pdImage.setColorSpace((PDColorSpace)PDCSDeviceGray.SINGLETON);
        return pdImage;
    }

    protected static PDImage createPdImage(PDImage basePdImage, int[] maskArray) {
        return ColorKeyMaskImage.createPdImage(basePdImage, null, maskArray);
    }

    public ColorKeyMaskImage(PDImage basePdImage, byte[] eightBpcBytes, int[] maskArray) {
        super(ColorKeyMaskImage.createPdImage(basePdImage, eightBpcBytes, maskArray));
    }

    public ColorKeyMaskImage(PDImage basePdImage, int[] maskArray) {
        this(basePdImage, null, maskArray);
    }
}

