/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.image;

import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.image.ColorAttribute;
import de.intarsys.pdf.platform.cwt.image.ColorKeyMaskImage;
import de.intarsys.pdf.platform.cwt.image.CwtColoredPlatformImage;
import de.intarsys.pdf.platform.cwt.image.CwtPlatformImage;
import de.intarsys.pdf.platform.cwt.image.IPlatformImage;
import de.intarsys.pdf.platform.cwt.image.IPlatformImageFactory;
import de.intarsys.pdf.platform.cwt.image.ImageMaskMaskImage;
import de.intarsys.pdf.platform.cwt.image.SMaskMaskImage;
import de.intarsys.tools.attribute.Attribute;

public class CwtPlatformImageFactory
implements IPlatformImageFactory {
    private static final Attribute ATTR_PLATFORMIMAGE = new Attribute("platformImage");

    @Override
    public synchronized IPlatformImage createPlatformImage(PDImage pdImage) {
        IPlatformImage result = (IPlatformImage)pdImage.getAttribute((Object)ATTR_PLATFORMIMAGE);
        if (result == null) {
            result = new CwtPlatformImage(pdImage);
            pdImage.setAttribute((Object)ATTR_PLATFORMIMAGE, (Object)result);
        }
        return result;
    }

    @Override
    public IPlatformImage createPlatformImage(PDImage pdImage, PDColorSpace colorSpace, float[] colorValues) {
        ColorAttribute attribute = new ColorAttribute(colorSpace, colorValues);
        IPlatformImage result = (IPlatformImage)pdImage.getAttribute((Object)attribute);
        if (result == null) {
            result = new CwtColoredPlatformImage(pdImage, colorSpace, colorValues);
            pdImage.setAttribute((Object)attribute, (Object)result);
        }
        return result;
    }

    @Override
    public IPlatformImage createPlatformMaskImage(PDImage pdImage) {
        return this.createPlatformMaskImage(pdImage, null);
    }

    @Override
    public IPlatformImage createPlatformMaskImage(PDImage pdImage, byte[] eightBpcBytes) {
        PDImage maskPdImage = pdImage.getSMask();
        if (maskPdImage != null) {
            if (maskPdImage.getBitsPerComponent() == 8) {
                return new CwtPlatformImage(maskPdImage);
            }
            return new SMaskMaskImage(maskPdImage);
        }
        maskPdImage = pdImage.getMaskImage();
        if (maskPdImage != null) {
            return new ImageMaskMaskImage(maskPdImage);
        }
        int[] maskArray = pdImage.getMaskArray();
        if (maskArray != null) {
            return new ColorKeyMaskImage(pdImage, eightBpcBytes, maskArray);
        }
        return null;
    }
}

