/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.image;

import de.intarsys.pdf.pd.PDCSDeviceGray;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.image.CwtPlatformImage;

public class ImageMaskMaskImage
extends CwtPlatformImage {
    private static final byte[] ValueMapping = new byte[]{-1, 0};

    protected static byte[] create8BPCBytes(PDImage sourcePdImage) {
        int width = sourcePdImage.getWidth();
        int height = sourcePdImage.getHeight();
        byte[] sourceBytes = sourcePdImage.getAdjustedBytes();
        byte[] resultBytes = new byte[width * height];
        int scanline = (width + 7) / 8;
        for (int y = 0; y < height; ++y) {
            int sourceOffset = y * scanline;
            for (int byteIndex = 0; byteIndex < width / 8; ++byteIndex) {
                byte value = sourceBytes[sourceOffset + byteIndex];
                int resultOffset = y * width + byteIndex * 8;
                resultBytes[resultOffset] = ValueMapping[value >> 7 & 1];
                resultBytes[resultOffset + 1] = ValueMapping[value >> 6 & 1];
                resultBytes[resultOffset + 2] = ValueMapping[value >> 5 & 1];
                resultBytes[resultOffset + 3] = ValueMapping[value >> 4 & 1];
                resultBytes[resultOffset + 4] = ValueMapping[value >> 3 & 1];
                resultBytes[resultOffset + 5] = ValueMapping[value >> 2 & 1];
                resultBytes[resultOffset + 6] = ValueMapping[value >> 1 & 1];
                resultBytes[resultOffset + 7] = ValueMapping[value & 1];
            }
            if (width % 8 == 0) continue;
            byte value = sourceBytes[sourceOffset + scanline - 1];
            int resultOffset = y * width + width / 8 * 8;
            for (int bitIndex = 0; bitIndex < width % 8; ++bitIndex) {
                resultBytes[resultOffset + bitIndex] = ValueMapping[value >> 7 - bitIndex & 1];
            }
        }
        return resultBytes;
    }

    protected static PDImage createPdImage(PDImage sourcePdImage) {
        PDImage pdImage = (PDImage)PDImage.META.createNew();
        pdImage.setWidth(sourcePdImage.getWidth());
        pdImage.setHeight(sourcePdImage.getHeight());
        pdImage.setBitsPerComponent(8);
        pdImage.setBytes(ImageMaskMaskImage.create8BPCBytes(sourcePdImage));
        pdImage.setColorSpace((PDColorSpace)PDCSDeviceGray.SINGLETON);
        return pdImage;
    }

    public ImageMaskMaskImage(PDImage maskImage) {
        super(ImageMaskMaskImage.createPdImage(maskImage));
    }
}

