/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.image;

import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.cwt.image.IImage;
import de.intarsys.cwt.image.IImageContainer;
import de.intarsys.cwt.image.ImageConvertOption;
import de.intarsys.cwt.image.ImageEntry;
import de.intarsys.pdf.content.common.CSCreator;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.pd.PDXObject;
import de.intarsys.pdf.platform.cwt.image.CwtPlatformImage;
import de.intarsys.pdf.platform.cwt.image.IPlatformImage;

public class PDImageEntry
extends ImageEntry<IPlatformImage>
implements IPlatformImage {
    private PDImage pdImage;

    public PDImageEntry(IImageContainer container, PDImage pdImage) {
        super(container);
        this.pdImage = pdImage;
    }

    public <T extends IImage> T asImage(Class<T> qualifier, ImageConvertOption ... options) {
        return (T)((IPlatformImage)this.getDelegate()).asImage(qualifier, options);
    }

    @Override
    public void drawContentStream(CSCreator creator, float x, float y) {
        creator.saveState();
        creator.transform((float)this.getWidth(), 0.0f, 0.0f, (float)this.getHeight(), x, y);
        creator.doXObject(null, (PDXObject)this.pdImage);
        creator.restoreState();
    }

    public void drawGraphics(IGraphicsContext graphicsContext, float x, float y) {
        graphicsContext.drawImage(this.getDelegate(), x, y);
    }

    protected synchronized IPlatformImage getErrorImage(Throwable t) {
        return null;
    }

    public int getIndex() {
        return 0;
    }

    @Override
    public PDImage getPDImage() {
        return this.pdImage;
    }

    public Class<IPlatformImage> getType() {
        return IPlatformImage.class;
    }

    protected IPlatformImage loadContent() {
        return new CwtPlatformImage(this.pdImage);
    }
}

