/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.image;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.tools.exception.UnreachableCodeError;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;

public class PDImageMetadata {
    public static final String MetadataFormatName = "de_intarsys_pdf_platform_cwt_image_1.0";
    private PDImage pdImage;

    public PDImageMetadata(PDImage pdImage) {
        this.pdImage = pdImage;
    }

    public Document getDocument() {
        DOMImplementation domImplementation;
        try {
            domImplementation = DOMImplementationRegistry.newInstance().getDOMImplementation("");
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new UnreachableCodeError();
        }
        Document document = domImplementation.createDocument(null, "root", null);
        Element indexNode = document.createElement("image_0");
        document.getDocumentElement().appendChild(indexNode);
        Element metadataNode = document.createElement(MetadataFormatName);
        indexNode.appendChild(metadataNode);
        Element dictNode = document.createElement("Dict");
        dictNode.setAttribute("BitsPerComponent", String.valueOf(this.pdImage.getBitsPerComponent()));
        PDColorSpace colorSpace = this.pdImage.getColorSpace();
        COSArray cosArray = colorSpace.cosGetObject().asArray();
        String colorSpaceString = cosArray != null ? cosArray.get(0).toString() : colorSpace.toString();
        dictNode.setAttribute("ColorSpace", colorSpaceString);
        dictNode.setAttribute("Height", String.valueOf(this.pdImage.getHeight()));
        dictNode.setAttribute("Width", String.valueOf(this.pdImage.getWidth()));
        metadataNode.appendChild(dictNode);
        return document;
    }
}

