/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.image;

import de.intarsys.pdf.pd.PDCSDeviceGray;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.image.CwtPlatformImage;

public class SMaskMaskImage
extends CwtPlatformImage {
    private static final int[][] ValueMapping = new int[][]{null, {0, 255}, {0, 85, 170, 255}, null, {0, 17, 34, 51, 68, 85, 102, 119, 136, 153, 170, 187, 204, 221, 238, 255}};

    protected static PDImage createPdImage(PDImage sourcePdImage) {
        PDImage pdImage = (PDImage)PDImage.META.createNew();
        pdImage.setWidth(sourcePdImage.getWidth());
        pdImage.setHeight(sourcePdImage.getHeight());
        pdImage.setBitsPerComponent(8);
        pdImage.setBytes(SMaskMaskImage.create8BPCBytes(sourcePdImage));
        pdImage.setColorSpace((PDColorSpace)PDCSDeviceGray.SINGLETON);
        return pdImage;
    }

    protected static byte[] create8BPCBytes(PDImage sourcePdImage) {
        int width = sourcePdImage.getWidth();
        int height = sourcePdImage.getHeight();
        int bitsPerComponent = sourcePdImage.getBitsPerComponent();
        byte[] sourceBytes = sourcePdImage.getAdjustedBytes();
        byte[] resultBytes = new byte[width * height];
        int scanline = (width * bitsPerComponent + 7) / 8;
        int pixelsPerByte = 8 / bitsPerComponent;
        int[] valueMapping = ValueMapping[bitsPerComponent];
        int bitMask = valueMapping.length - 1;
        for (int y = 0; y < height; ++y) {
            int sourceOffset = y * scanline;
            for (int byteIndex = 0; byteIndex < width / pixelsPerByte; ++byteIndex) {
                byte value = sourceBytes[sourceOffset + byteIndex];
                int resultOffset = y * width + byteIndex * pixelsPerByte;
                for (int bitIndex = 0; bitIndex < 8; bitIndex += bitsPerComponent) {
                    resultBytes[resultOffset + bitIndex / bitsPerComponent] = (byte)valueMapping[value >> 8 - bitsPerComponent - bitIndex & bitMask];
                }
            }
            if (width % pixelsPerByte == 0) continue;
            byte value = sourceBytes[sourceOffset + scanline - 1];
            int resultOffset = y * width + width / pixelsPerByte * pixelsPerByte;
            for (int bitIndex = 0; bitIndex < width % pixelsPerByte * bitsPerComponent; bitIndex += bitsPerComponent) {
                resultBytes[resultOffset + bitIndex / bitsPerComponent] = (byte)valueMapping[value >> 8 - bitsPerComponent - bitIndex & bitMask];
            }
        }
        return resultBytes;
    }

    public SMaskMaskImage(PDImage maskPdImage) {
        super(SMaskMaskImage.createPdImage(maskPdImage));
    }
}

