/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.paint;

import de.intarsys.cwt.common.IPaint;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.pdf.pd.PDShading;
import de.intarsys.pdf.platform.cwt.adapter.GraphicsEnvironmentAdapterRegistry;
import de.intarsys.pdf.platform.cwt.adapter.IGraphicsEnvironmentAdapter;
import de.intarsys.pdf.platform.cwt.paint.AbstractPaint;

public class ShadingPaint
extends AbstractPaint {
    private float alphaValue;
    private PDShading shading;

    public ShadingPaint(PDShading shading) {
        this.shading = shading;
        this.alphaValue = 1.0f;
    }

    public IPaint copy() {
        ShadingPaint copy = new ShadingPaint(this.shading);
        copy.alphaValue = this.alphaValue;
        copy.shading = this.shading;
        return copy;
    }

    public float getAlphaValue() {
        return this.alphaValue;
    }

    public PDShading getPdShading() {
        return this.shading;
    }

    public void setAlphaValue(float value) {
        this.alphaValue = value;
    }

    public void setBackgroundPaintFromGraphicsContext(IGraphicsContext graphicsContext) {
        IGraphicsEnvironmentAdapter adapter = GraphicsEnvironmentAdapterRegistry.get().lookupGraphicsEnvironmentAdapter(graphicsContext.getGraphicsEnvironment());
        adapter.setBackgroundShadingPaint(graphicsContext, this);
    }

    public void setForegroundPaintFromGraphicsContext(IGraphicsContext graphicsContext) {
        IGraphicsEnvironmentAdapter adapter = GraphicsEnvironmentAdapterRegistry.get().lookupGraphicsEnvironmentAdapter(graphicsContext.getGraphicsEnvironment());
        adapter.setForegroundShadingPaint(graphicsContext, this);
    }
}

