/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.ntp;

import de.intarsys.tools.component.CommonStartStop;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.component.IStartStop;
import de.intarsys.tools.date.IDateEnvironment;
import de.intarsys.tools.date.StandardDateEnvironment;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.ntp.CommonDateEnvironment;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedDateEnvironment
extends CommonDateEnvironment
implements IElementConfigurable,
IElementSerializable,
IStartStop {
    private static final String EL_REFERENCE_TIME_PROVIDER = "referenceTimeProvider";
    private static final int TIMEOUT = 2000;
    private static final String ATTR_MAX_TIME_FIX = "maxTimeFix";
    private static final String ATTR_DELAY = "delay";
    private static final int DEFAULT_DELAY = 60000;
    private static final Logger Log = LoggerFactory.getLogger(FixedDateEnvironment.class);
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable pR) {
            Thread t = new Thread(pR, "TimeServer update thread");
            t.setDaemon(true);
            return t;
        }
    });
    private long delay = 60000L;
    private long maxTimeFix;
    private volatile long timeFix;
    private final Runnable timeFixCommand = new Runnable(){

        @Override
        public void run() {
            FixedDateEnvironment.this.onTimeFix();
        }
    };
    private IDateEnvironment referenceTimeProvider;
    private final IStartStop lifecycleHandler = new CommonStartStop(){

        protected void basicStart() {
            FixedDateEnvironment.this.basicStart();
        }

        protected void basicStop() {
            FixedDateEnvironment.this.basicStop();
        }

        public boolean stopRequested(Set visited) {
            return FixedDateEnvironment.this.basicStopRequested(visited);
        }
    };

    protected void basicStart() {
        if (this.getReferenceTimeProvider() instanceof IStartStop) {
            ((IStartStop)this.getReferenceTimeProvider()).start();
        }
        try {
            Future<?> firstTimeRequest = this.executor.submit(this.timeFixCommand);
            firstTimeRequest.get(2000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Log.warn("{} start interrupted ({})", (Object)this, (Object)ExceptionTools.getMessage((Throwable)e));
        }
        catch (Exception e) {
            Log.warn("{} start failed ({})", (Object)this, (Object)ExceptionTools.getMessage((Throwable)e));
        }
        this.executor.scheduleWithFixedDelay(this.timeFixCommand, this.getDelay(), this.getDelay(), TimeUnit.MILLISECONDS);
    }

    protected void basicStop() {
        this.executor.shutdownNow();
        if (this.getReferenceTimeProvider() instanceof IStartStop) {
            ((IStartStop)this.getReferenceTimeProvider()).stop();
        }
    }

    protected boolean basicStopRequested(Set visited) {
        if (this.getReferenceTimeProvider() instanceof IStartStop) {
            return ((IStartStop)this.getReferenceTimeProvider()).stopRequested(visited);
        }
        return true;
    }

    protected void check() {
        if (this.getMaxTimeFix() <= 0L || Math.abs(this.timeFix) > this.getMaxTimeFix()) {
            // empty if block
        }
    }

    public void configure(IElement element) throws ConfigurationException {
        IElement eReferenceTimeProvider = element.element(EL_REFERENCE_TIME_PROVIDER);
        try {
            this.setReferenceTimeProvider((IDateEnvironment)ElementTools.createObject((IElement)eReferenceTimeProvider, IDateEnvironment.class, (Object)this, (IArgs)Args.create()));
        }
        catch (ObjectCreationException e) {
            throw new ConfigurationException((Throwable)e);
        }
        this.setDelay(ElementTools.getLong((IElement)element, (String)ATTR_DELAY, (long)this.getDelay()));
        this.setMaxTimeFix(ElementTools.getLong((IElement)element, (String)ATTR_MAX_TIME_FIX, (long)this.getMaxTimeFix()));
    }

    public long getDelay() {
        return this.delay;
    }

    public long getMaxTimeFix() {
        return this.maxTimeFix;
    }

    public IDateEnvironment getReferenceTimeProvider() {
        if (this.referenceTimeProvider == null) {
            this.referenceTimeProvider = new StandardDateEnvironment();
        }
        return this.referenceTimeProvider;
    }

    protected long getTime() {
        return System.currentTimeMillis() + this.timeFix;
    }

    protected long getTimeFix() {
        return this.timeFix;
    }

    public boolean isStarted() {
        return this.lifecycleHandler.isStarted();
    }

    public Date now() {
        return new Date(this.getTime());
    }

    protected void onTimeFix() {
        this.timeFix = this.getReferenceTimeProvider().now().getTime() - System.currentTimeMillis();
        this.check();
    }

    public void serialize(IElement element) throws ElementSerializationException {
        if (this.referenceTimeProvider != null) {
            ElementTools.putObject((IElement)element, (String)EL_REFERENCE_TIME_PROVIDER, (Object)this.referenceTimeProvider);
        }
        element.setAttributeValue(ATTR_DELAY, String.valueOf(this.getDelay()));
        element.setAttributeValue(ATTR_MAX_TIME_FIX, String.valueOf(this.getMaxTimeFix()));
    }

    public void setDelay(long pDelay) {
        this.delay = pDelay;
    }

    public void setMaxTimeFix(long pMaxTimeFix) {
        this.maxTimeFix = pMaxTimeFix;
    }

    public void setReferenceTimeProvider(IDateEnvironment referenceTimeProvider) {
        this.referenceTimeProvider = referenceTimeProvider;
    }

    public void start() {
        this.lifecycleHandler.start();
        Log.info("DateEnvironment is {}", (Object)this);
        Log.info("+- System.currentTimeMillis() {}", (Object)System.currentTimeMillis());
        Log.info("+- DateEnvironment.now() {}", (Object)this.now().getTime());
    }

    public void stop() {
        this.lifecycleHandler.stop();
    }

    public boolean stopRequested(Set visited) {
        return this.lifecycleHandler.stopRequested(visited);
    }
}

