/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.ntp;

import de.intarsys.tools.component.CommonStartStop;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.component.IStartStop;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.jmx.MBeanSupport;
import de.intarsys.tools.ntp.CommonDateEnvironment;
import de.intarsys.tools.ntp.NTPUDPClient;
import de.intarsys.tools.ntp.auth.INTPAuthenticator;
import de.intarsys.tools.ntp.auth.INTPKeyMap;
import java.io.IOException;
import java.net.InetAddress;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.JMException;
import javax.management.NotificationBroadcasterSupport;
import org.apache.commons.net.ntp.TimeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class NTPDateEnvironment
extends CommonDateEnvironment
implements IElementConfigurable,
IElementSerializable,
IStartStop {
    private static final String ATTR_TIMEOUT = "timeout";
    private static final String EL_SERVER = "server";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_KEY_ID = "keyId";
    private static final int DEFAULT_TIMEOUT = 1000;
    private static final Logger Log = LoggerFactory.getLogger(NTPDateEnvironment.class);
    private List<Server> servers = new ArrayList<Server>();
    private int timeout = 1000;
    private boolean available = true;
    private volatile long timeFix;
    private INTPKeyMap keyMap;
    private final MBeanSupport mbeanSupport = new MBeanSupport(){

        protected NotificationBroadcasterSupport mbeanCreate() {
            return new NTPDateEnvironmentMBean();
        }

        protected void mbeanDeclareProperties(Hashtable<String, String> properties) {
            properties.put("type", "ntp");
        }

        protected String mbeanGetDomain() {
            return "de.intarsys.time";
        }
    };
    private final IStartStop livecycleHandler = new CommonStartStop(){

        protected void basicStart() {
            NTPDateEnvironment.this.basicStart();
        }

        protected void basicStop() {
            NTPDateEnvironment.this.basicStop();
        }
    };

    public void addServer(Server server) {
        this.servers.add(server);
        Log.info("{} added NTP server {}", (Object)this, (Object)server);
    }

    public void addServer(String url) {
        this.addServer(Server.parse(url));
    }

    protected void basicStart() {
        try {
            this.mbeanSupport.mbeanPublish();
        }
        catch (JMException e) {
            Log.warn("{} error publishing MBean ({})", (Object)this, (Object)ExceptionTools.getMessage((Throwable)e));
        }
    }

    protected void basicStop() {
        try {
            this.mbeanSupport.mbeanUnpublish();
        }
        catch (JMException e) {
            Log.warn("{} error unpublishing MBean ({})", (Object)this, (Object)ExceptionTools.getMessage((Throwable)e));
        }
    }

    public void configure(IElement element) throws ConfigurationException {
        this.setDefaultTimeout(ElementTools.getInt((IElement)element, (String)ATTR_TIMEOUT, (int)1000));
        Iterator i = element.elementIterator(EL_SERVER);
        while (i.hasNext()) {
            IElement eServer = (IElement)i.next();
            String serverName = eServer.attributeValue(ATTR_NAME, null);
            if (serverName == null) continue;
            Server server = new Server(serverName);
            String keyId = ElementTools.getString((IElement)eServer, (String)ATTR_KEY_ID, null);
            if (keyId != null) {
                server.setKeyId(Integer.parseInt(keyId));
            }
            this.addServer(server);
        }
        if (this.getServers().isEmpty()) {
            Log.info("No NTP server configured");
        }
    }

    public int getDefaultTimeout() {
        return this.timeout;
    }

    public INTPKeyMap getKeyMap() {
        return this.keyMap;
    }

    public List<Server> getServers() {
        return new ArrayList<Server>(this.servers);
    }

    protected TimeInfo getTimeInfo() throws IOException {
        for (Server server : this.getServers()) {
            try {
                return this.getTimeInfo(server);
            }
            catch (IOException e) {
                if (Log.isEnabledForLevel(Level.DEBUG)) {
                    Log.warn("{} error fetching time ({})", (Object)this, (Object)ExceptionTools.getMessage((Throwable)e));
                    continue;
                }
                Log.warn("{} error fetching time", (Object)this, (Object)e);
            }
        }
        throw new IOException("No time info acquired.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TimeInfo getTimeInfo(Server server) throws IOException {
        NTPUDPClient client = new NTPUDPClient();
        if (server.getKeyId() != null) {
            INTPAuthenticator authenticator;
            if (this.getKeyMap() == null) {
                throw new IllegalStateException("key map missing");
            }
            try {
                authenticator = this.getKeyMap().createAuthenticator(server.getKeyId());
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException(e);
            }
            client.setAuthenticator(authenticator);
        }
        client.setDefaultTimeout(this.getDefaultTimeout());
        try {
            client.open();
            InetAddress hostAddr = InetAddress.getByName(server.getName());
            TimeInfo info = client.getTime(hostAddr);
            Log.debug("NTPTimeServer {} received time {}", (Object)server, (Object)info.getMessage().getReceiveTimeStamp().getDate());
            TimeInfo timeInfo = info;
            return timeInfo;
        }
        finally {
            client.close();
        }
    }

    public boolean isAvailable() {
        return this.available;
    }

    public boolean isStarted() {
        return this.livecycleHandler.isStarted();
    }

    public Date now() {
        if (this.getServers().isEmpty()) {
            Log.warn("{}, no NTP servers configured, falling back to Local system time.", (Object)this);
            this.setAvailable(false);
            return new Date();
        }
        try {
            TimeInfo timeInfo = this.getTimeInfo();
            Date time = timeInfo.getMessage().getReceiveTimeStamp().getDate();
            this.setAvailable(true);
            this.timeFix = time.getTime() - System.currentTimeMillis();
            return time;
        }
        catch (IOException iOException) {
            this.setAvailable(false);
            return new Date(System.currentTimeMillis() + this.timeFix);
        }
    }

    public void serialize(IElement element) throws ElementSerializationException {
        element.setAttributeValue("class", this.getClass().getName());
        element.setAttributeValue(ATTR_TIMEOUT, String.valueOf(this.getDefaultTimeout()));
        for (Server server : this.getServers()) {
            IElement eServer = element.newElementMapped(EL_SERVER);
            eServer.setAttributeValue(ATTR_NAME, server.getName());
            if (server.getKeyId() == null) continue;
            eServer.setAttributeValue(ATTR_KEY_ID, String.valueOf(server.getKeyId()));
        }
    }

    protected void setAvailable(boolean newAvailable) {
        if (this.available == newAvailable) {
            return;
        }
        boolean oldAvailable = this.available;
        this.available = newAvailable;
        if (oldAvailable) {
            this.mbeanSupport.mbeanSendNotification("time.unavailable", "network time is not available.");
        } else {
            this.mbeanSupport.mbeanSendNotification("time.available", "Network time is available again.");
        }
    }

    public void setDefaultTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setKeyMap(INTPKeyMap keyMap) {
        this.keyMap = keyMap;
    }

    public void setServers(List<Server> servers) {
        this.servers = servers;
    }

    public void start() {
        this.livecycleHandler.start();
        Log.info("DateEnvironment is {}", (Object)this);
        Log.info("+- System.currentTimeMillis() {}", (Object)System.currentTimeMillis());
        Log.info("+- DateEnvironment.now() {}", (Object)this.now().getTime());
    }

    public void stop() {
        this.livecycleHandler.stop();
    }

    public boolean stopRequested(Set visited) {
        return this.livecycleHandler.stopRequested(visited);
    }

    public static class Server {
        private static final String KEY_DELIM = " key ";
        private final String name;
        private Integer keyId;

        public static Server parse(String definition) {
            String keyDelim;
            String myDefinition = definition.trim();
            int keyIndex = myDefinition.indexOf(keyDelim = KEY_DELIM);
            if (keyIndex < 0) {
                return new Server(myDefinition);
            }
            String name = myDefinition.substring(0, keyIndex);
            String keyIdDef = myDefinition.substring(keyIndex + keyDelim.length());
            int keyId = Integer.parseInt(keyIdDef);
            return new Server(name, keyId);
        }

        public Server(String name) {
            this.name = name;
        }

        public Server(String name, int keyId) {
            this.name = name;
            this.keyId = keyId;
        }

        public Integer getKeyId() {
            return this.keyId;
        }

        public String getName() {
            return this.name;
        }

        public void setKeyId(Integer keyId) {
            this.keyId = keyId;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getName());
            if (this.getKeyId() != null) {
                sb.append(KEY_DELIM).append(this.getKeyId());
            }
            return sb.toString();
        }
    }

    public static interface NTPDateEnvironmentMBeanMBean {
    }

    public class NTPDateEnvironmentMBean
    extends NotificationBroadcasterSupport
    implements NTPDateEnvironmentMBeanMBean {
    }
}

