/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.ntp;

import de.intarsys.tools.ntp.auth.INTPAuthenticator;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import org.apache.commons.net.DatagramSocketClient;
import org.apache.commons.net.ntp.NtpV3Impl;
import org.apache.commons.net.ntp.NtpV3Packet;
import org.apache.commons.net.ntp.TimeInfo;
import org.apache.commons.net.ntp.TimeStamp;

public class NTPUDPClient
extends DatagramSocketClient {
    private static final INTPAuthenticator NULL_AUTHENTICATOR = new INTPAuthenticator(){

        @Override
        public void authenticatePacket(DatagramPacket packet) throws IOException {
        }

        @Override
        public DatagramPacket createReceivePacket(DatagramPacket packet) throws IOException {
            return packet;
        }

        @Override
        public DatagramPacket createSendPacket(DatagramPacket packet) throws IOException {
            return packet;
        }
    };
    public static final int DEFAULT_PORT = 123;
    private int version = 3;
    private INTPAuthenticator authenticator;

    public INTPAuthenticator getAuthenticator() {
        if (this.authenticator == null) {
            this.authenticator = NULL_AUTHENTICATOR;
        }
        return this.authenticator;
    }

    public TimeInfo getTime(InetAddress host) throws IOException {
        return this.getTime(host, 123);
    }

    public TimeInfo getTime(InetAddress host, int port) throws IOException {
        if (!this.isOpen()) {
            this.open();
        }
        NtpV3Impl message = new NtpV3Impl();
        message.setMode(3);
        message.setVersion(this.version);
        DatagramPacket sendPacket = message.getDatagramPacket();
        sendPacket.setAddress(host);
        sendPacket.setPort(port);
        NtpV3Impl recMessage = new NtpV3Impl();
        DatagramPacket receivePacket = recMessage.getDatagramPacket();
        TimeStamp now = TimeStamp.getCurrentTime();
        message.setTransmitTime(now);
        sendPacket = this.getAuthenticator().createSendPacket(sendPacket);
        receivePacket = this.getAuthenticator().createReceivePacket(receivePacket);
        this._socket_.send(sendPacket);
        this._socket_.receive(receivePacket);
        recMessage.setDatagramPacket(receivePacket);
        this.getAuthenticator().authenticatePacket(receivePacket);
        long returnTime = System.currentTimeMillis();
        TimeInfo info = new TimeInfo((NtpV3Packet)recMessage, returnTime, false);
        return info;
    }

    public int getVersion() {
        return this.version;
    }

    public void setAuthenticator(INTPAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void setVersion(int version) {
        this.version = version;
    }
}

