/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.ntp.auth;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.ntp.auth.INTPAuthenticator;
import de.intarsys.tools.ntp.auth.MD5Authenticator;
import de.intarsys.tools.ntp.auth.SHA1Authenticator;
import java.io.IOException;
import java.net.DatagramPacket;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public abstract class DigestAuthenticator
implements INTPAuthenticator,
IElementConfigurable,
IElementSerializable {
    private static final String ATTR_SECRET = "secret";
    private static final String ATTR_KEY_ID = "keyId";
    private static final String ATTR_KEY_ALGORITHM = "keyAlgorithm";
    private static final int HIGH_BYTE = 255;
    private static final int BYTE_SHIFT = 8;
    private static final int BYTES_INT = 4;
    private static final int BIT_SHIFT_8 = 8;
    private static final int BUF_INDEX_3 = 3;
    private static final int BUF_INDEX_2 = 2;
    private static final int BUF_INDEX_1 = 1;
    private static final int BUF_INDEX_0 = 0;
    private static final int BIT_SHIFT_24 = 24;
    private static final int KEY_LENGTH = 4;
    private static final int MESSAGE_LENGTH = 48;
    private static final Logger Log = LoggerFactory.getLogger(DigestAuthenticator.class);
    private static final int BIT_SHIFT_16 = 16;
    private int keyId;
    private byte[] keyIdEncoded;
    private String secret;

    public static INTPAuthenticator create(IElement eAuthenticator) throws ConfigurationException {
        INTPAuthenticator authenticator;
        String algorithm = ElementTools.getString((IElement)eAuthenticator, (String)ATTR_KEY_ALGORITHM, null);
        try {
            authenticator = DigestAuthenticator.create(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)e);
        }
        if (authenticator instanceof IElementConfigurable) {
            ((IElementConfigurable)authenticator).configure(eAuthenticator);
        }
        return authenticator;
    }

    public static INTPAuthenticator create(String algorithm) throws NoSuchAlgorithmException {
        DigestAuthenticator authenticator = null;
        if ("MD5".equals(algorithm)) {
            authenticator = new MD5Authenticator();
        } else if ("SHA1".equals(algorithm)) {
            authenticator = new SHA1Authenticator();
        } else {
            throw new NoSuchAlgorithmException("Unsupported algorithm: " + algorithm);
        }
        return authenticator;
    }

    protected static final int ui(byte b) {
        int i = b & 0xFF;
        return i;
    }

    protected DigestAuthenticator() {
    }

    protected DigestAuthenticator(int keyId, String passphrase) {
        this.keyId = keyId;
        this.secret = passphrase;
    }

    @Override
    public void authenticatePacket(DatagramPacket packet) throws IOException {
        if (Log.isEnabledForLevel(Level.DEBUG)) {
            Log.debug("Verifying NTP packet MAC (expected key id: {}, expected algorithm: {})", (Object)this.getKeyId(), (Object)this.getDigestAlgorithm());
        }
        int messageLength = 48;
        int keyIdLength = 4;
        if (packet.getLength() < messageLength + keyIdLength) {
            throw new IOException("key id missing");
        }
        byte[] packetKeyIdEncoded = new byte[keyIdLength];
        System.arraycopy(packet.getData(), packet.getOffset() + messageLength, packetKeyIdEncoded, 0, keyIdLength);
        int packetKeyId = this.byteToInt(packetKeyIdEncoded);
        if (packetKeyId != this.getKeyId()) {
            throw new IOException("unexpected key id: " + packetKeyId);
        }
        byte[] message = new byte[messageLength];
        System.arraycopy(packet.getData(), packet.getOffset(), message, 0, messageLength);
        byte[] mac = this.calculateMac(message, this.getKey(), this.getDigestAlgorithm());
        if (packet.getLength() < messageLength + keyIdLength + mac.length) {
            throw new IOException("mac missing");
        }
        byte[] packetMac = new byte[mac.length];
        System.arraycopy(packet.getData(), packet.getOffset() + messageLength + keyIdLength, packetMac, 0, mac.length);
        if (!Arrays.equals(packetMac, mac)) {
            throw new IOException("invalid mac");
        }
        if (Log.isEnabledForLevel(Level.DEBUG)) {
            Log.debug("NTP packet successfully authenticated");
        }
    }

    private int byteToInt(byte[] buf) {
        int i = DigestAuthenticator.ui(buf[0]) << 24 | DigestAuthenticator.ui(buf[1]) << 16 | DigestAuthenticator.ui(buf[2]) << 8 | DigestAuthenticator.ui(buf[3]);
        return i;
    }

    protected byte[] calculateMac(byte[] message, byte[] key, String digestAlgorithm) throws IOException {
        IDigest digest;
        byte[] macInput = new byte[key.length + message.length];
        System.arraycopy(key, 0, macInput, 0, key.length);
        System.arraycopy(message, 0, macInput, key.length, message.length);
        try {
            digest = DigestTools.createDigester((String)digestAlgorithm).digest(macInput);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        byte[] mac = digest.getBytes();
        return mac;
    }

    public void configure(IElement element) throws ConfigurationException {
        this.setKeyId(ElementTools.getInt((IElement)element, (String)ATTR_KEY_ID, (int)-1));
        this.setSecret(ElementTools.getString((IElement)element, (String)ATTR_SECRET, null));
    }

    @Override
    public DatagramPacket createReceivePacket(DatagramPacket packet) throws IOException {
        int macLength = this.getMacLength();
        byte[] result = new byte[packet.getData().length + this.getKeyIdEncoded().length + macLength];
        DatagramPacket resultPacket = new DatagramPacket(result, result.length);
        return resultPacket;
    }

    @Override
    public DatagramPacket createSendPacket(DatagramPacket packet) throws IOException {
        if (Log.isEnabledForLevel(Level.DEBUG)) {
            Log.debug("Computing NTP packet MAC (key id: " + this.getKeyId() + ", algorithm: " + this.getDigestAlgorithm() + ")");
        }
        byte[] myKeyId = this.getKeyIdEncoded();
        byte[] message = new byte[packet.getLength()];
        System.arraycopy(packet.getData(), packet.getOffset(), message, 0, packet.getLength());
        byte[] mac = this.calculateMac(message, this.getKey(), this.getDigestAlgorithm());
        byte[] result = new byte[message.length + myKeyId.length + mac.length];
        System.arraycopy(message, 0, result, 0, message.length);
        int pos = message.length;
        System.arraycopy(myKeyId, 0, result, pos, myKeyId.length);
        System.arraycopy(mac, 0, result, pos += myKeyId.length, mac.length);
        DatagramPacket resultPacket = new DatagramPacket(result, result.length);
        resultPacket.setAddress(packet.getAddress());
        resultPacket.setPort(packet.getPort());
        if (Log.isEnabledForLevel(Level.DEBUG)) {
            Log.debug("MAC attached");
        }
        return resultPacket;
    }

    protected abstract String getDigestAlgorithm();

    protected abstract byte[] getKey();

    public int getKeyId() {
        return this.keyId;
    }

    public byte[] getKeyIdEncoded() {
        if (this.keyIdEncoded == null) {
            this.keyIdEncoded = this.intToBytes(this.getKeyId());
        }
        return this.keyIdEncoded;
    }

    protected abstract int getMacLength();

    public String getSecret() {
        return this.secret;
    }

    private byte[] intToBytes(int value) {
        int myValue = value;
        byte[] buf = new byte[4];
        for (int i = buf.length - 1; i >= 0; --i) {
            buf[i] = (byte)(myValue & 0xFF);
            myValue >>>= 8;
        }
        return buf;
    }

    public void serialize(IElement element) throws ElementSerializationException {
        element.setAttributeValue(ATTR_KEY_ALGORITHM, this.getDigestAlgorithm());
        element.setAttributeValue(ATTR_KEY_ID, String.valueOf(this.getKeyId()));
        element.setAttributeValue(ATTR_SECRET, this.getSecret());
    }

    public void setKeyId(int keyId) {
        this.keyId = keyId;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }
}

