/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.ntp.auth;

import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.ntp.auth.INTPAuthenticator;
import de.intarsys.tools.ntp.auth.INTPKeyMap;
import de.intarsys.tools.ntp.auth.NTPKey;
import de.intarsys.tools.stream.StreamTools;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public class NTPKeyFile
implements INTPKeyMap {
    private static final int MIN_LENGTH = 3;
    private final Map<Integer, NTPKey> keys = new HashMap<Integer, NTPKey>();

    public static NTPKeyFile createFromLocator(ILocator locator) throws IOException {
        NTPKeyFile file = new NTPKeyFile();
        file.reload(locator);
        return file;
    }

    public void addKeyDefinition(NTPKey keyDefinition) {
        this.keys.put(keyDefinition.getId(), keyDefinition);
    }

    @Override
    public INTPAuthenticator createAuthenticator(int keyId) throws NoSuchAlgorithmException {
        NTPKey ntpKey = this.getKeyDefinition(keyId);
        if (ntpKey == null) {
            throw new IllegalArgumentException("Invalid key id: " + keyId);
        }
        return ntpKey.createAuthenticator();
    }

    public NTPKey getKeyDefinition(int keyId) {
        NTPKey ntpKey = this.keys.get(keyId);
        return ntpKey;
    }

    protected void processKeyDefinition(String line, int index) throws IOException {
        String myLine = line.trim();
        if (myLine.isEmpty() || myLine.startsWith("#")) {
            return;
        }
        String[] split = myLine.split(" ");
        if (split.length < 3) {
            throw new IOException("Error in line " + index + ": 3 elements required (keyId algorithm secret)");
        }
        NTPKey key = new NTPKey();
        key.setId(Integer.parseInt(split[0]));
        key.setAlgorithm(split[1]);
        key.setSecret(split[2]);
        this.addKeyDefinition(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(ILocator locator) throws IOException {
        this.keys.clear();
        BufferedReader r = null;
        try {
            r = new BufferedReader(locator.getReader());
            int lineIndex = 1;
            String line = r.readLine();
            while (line != null) {
                this.processKeyDefinition(line, lineIndex++);
                line = r.readLine();
            }
        }
        catch (Throwable throwable) {
            StreamTools.close(r);
            throw throwable;
        }
        StreamTools.close((Closeable)r);
    }

    public int size() {
        return this.keys.size();
    }
}

