/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font;

import de.intarsys.cwt.font.CommonFontStore;
import de.intarsys.cwt.font.FontTools;
import de.intarsys.cwt.font.IFont;
import de.intarsys.cwt.font.IFontRegistry;
import de.intarsys.cwt.freetype.Library;
import de.intarsys.tools.installresource.InstallFileList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoaderFontStore
extends CommonFontStore {
    private static final Logger Log = LoggerFactory.getLogger(ClassLoaderFontStore.class);
    private ClassLoader classLoader;

    public ClassLoaderFontStore(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void load(Library library, IFontRegistry fontRegistry, Object logPrefix) {
        this.loadFontClassLoader(library, fontRegistry, logPrefix);
    }

    protected void loadFontClassLoader(Library library, IFontRegistry fontRegistry, Object logPrefix) {
        try {
            InstallFileList installer = new InstallFileList("fonts", "fonts.list", false);
            installer.setClassLoader(this.classLoader);
            installer.loadAll();
            File[] roots = installer.getFiles();
            for (int i = 0; i < roots.length; ++i) {
                Path root = roots[i].toPath();
                Files.newDirectoryStream(root).forEach(file -> {
                    try {
                        this.processFontFile(library, fontRegistry, logPrefix, (Path)file);
                    }
                    catch (IOException ex) {
                        Log.warn("{} error loading font '{}'", new Object[]{logPrefix, file.getFileName(), ex});
                    }
                });
            }
        }
        catch (IOException ex) {
            Log.warn("{} error looking up 'font/fonts.list' resources", logPrefix, (Object)ex);
        }
    }

    protected void processFontFile(Library library, IFontRegistry fontRegistry, Object logPrefix, Path file) throws IOException {
        IFont font = this.loadFontUnchecked(library, fontRegistry, logPrefix, file.toAbsolutePath().toString());
        if (font == null) {
            return;
        }
        FontTools.mapFont(font.getFontName(), font);
    }
}

