/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font;

import de.intarsys.cwt.font.GenericFont;
import de.intarsys.cwt.font.IFont;
import de.intarsys.cwt.font.IFontRegistry;
import de.intarsys.cwt.font.IFontStore;
import de.intarsys.cwt.freetype.Face;
import de.intarsys.cwt.freetype.Library;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonFontStore
implements IFontStore {
    private static final Logger Log = LoggerFactory.getLogger(CommonFontStore.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IFont loadFontUnchecked(Library library, IFontRegistry fontRegistry, Object logPrefix, String filepath) {
        FileLocator locator = new FileLocator(filepath);
        Face face = library.newFace(filepath, 0);
        if (face != null) {
            GenericFont font = null;
            try {
                font = GenericFont.createNew((ILocator)locator, face);
                fontRegistry.registerFont(font);
            }
            finally {
                face.doneFace();
            }
            Log.debug("{} loaded font '{}' from {}", new Object[]{logPrefix, font.getFontNameCanonical(), filepath});
            return font;
        }
        Log.debug("{} can't load font from {}", logPrefix, (Object)filepath);
        return null;
    }
}

